#include "mex.h"
#include "matrix.h"
#include "math.h"
#include "stdio.h"

void mexFunction( int nlhs, mxArray *plhs[],
                  int nrhs, const mxArray *prhs[] )

{

    /* -- Inputs -- */
	double *nin			= mxGetPr(prhs[0]);
	double *nxin		= mxGetPr(prhs[1]);
	double *nyin		= mxGetPr(prhs[2]);
    double *xss 		= mxGetPr(prhs[3]);
    double *yss 		= mxGetPr(prhs[4]);
	double *parmin 		= mxGetPr(prhs[5]);
	double *nnuin 		= mxGetPr(prhs[6]);
	double *varphiin 	= mxGetPr(prhs[7]);
	double *sigspin  	= mxGetPr(prhs[8]);
	double *Hs  		= mxGetPr(prhs[9]);
	double *Gs 			= mxGetPr(prhs[10]);
	double *Gsp 		= mxGetPr(prhs[11]);
	double *G2sp 		= mxGetPr(prhs[12]);
	double *Psspin  	= mxGetPr(prhs[13]);
	double *dP1sspin	= mxGetPr(prhs[14]);
	double *dP2sspin	= mxGetPr(prhs[15]);

	/* -- Specific Inputs -- */
	int n 				= nin[0];
	int nx 				= nxin[0];
	int ny 				= nyin[0];
	double nnus 		= nnuin[0];
	double varphis 		= varphiin[0];
	double bbeta 		= parmin[0];
	double rrho 		= parmin[1];
	double oomega 		= parmin[2];
	double eeta 		= parmin[3];
	double aalpha 		= parmin[4];
	double ddelta 		= parmin[5];
	double pbar 		= parmin[6];
	double ebar 		= parmin[7];
	double iiota 		= parmin[8];
	double pphi 		= parmin[9];
	double rbar 		= parmin[10];
	double kkappa   	= parmin[11];
	double rrhoa 		= parmin[12];
	double rrhoz 		= parmin[13];
	double rrhop 		= parmin[14];
	double rrhor 		= parmin[15];
	double rrhoe 		= parmin[16];
	double rrhod 	 	= parmin[17];
	double varphibar 	= parmin[18];
	double bbar 		= parmin[19];
	double ppsir 		= parmin[20];
	double abar  		= parmin[21];
	double zbar 		= parmin[22];
	double ssigmaasp	= sigspin[0];
	double ssigmazsp	= sigspin[1];
	double ssigmapsp	= sigspin[2];
	double ssigmarsp	= sigspin[3];
	double ssigmaesp	= sigspin[4];
	double ssigmadsp	= sigspin[5];
	double Pssp 		= Psspin[0];
	double dP1ssp 		= dP1sspin[0];
	double dP2ssp 		= dP2sspin[0];

	/* -- Outputs -- */
	plhs[0] = mxCreateDoubleMatrix(n,n+ny,mxREAL);
	plhs[1] = mxCreateDoubleMatrix(n,1,mxREAL);
	double *Mcc_sp_s = mxGetPr(plhs[0]);
	double *Ncc_sp_s = mxGetPr(plhs[1]);

    /* -- Definition of Variables -- */
    double E = 2.71828182845905;


    /* -- Mathematica Output Here -- */
	Mcc_sp_s[168]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mcc_sp_s[192]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mcc_sp_s[216]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mcc_sp_s[384]=-(pow(E,yss[8])*Pssp);
	Mcc_sp_s[408]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mcc_sp_s[432]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mcc_sp_s[49]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mcc_sp_s[73]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mcc_sp_s[97]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mcc_sp_s[217]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mcc_sp_s[241]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mcc_sp_s[313]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mcc_sp_s[385]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mcc_sp_s[409]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mcc_sp_s[433]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mcc_sp_s[50]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mcc_sp_s[74]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mcc_sp_s[218]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mcc_sp_s[242]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mcc_sp_s[314]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mcc_sp_s[362]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mcc_sp_s[386]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mcc_sp_s[410]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mcc_sp_s[434]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mcc_sp_s[3]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mcc_sp_s[27]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mcc_sp_s[51]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mcc_sp_s[75]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mcc_sp_s[99]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mcc_sp_s[123]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mcc_sp_s[147]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mcc_sp_s[171]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mcc_sp_s[315]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mcc_sp_s[387]=-(pow(E,yss[8])*Pssp);
	Mcc_sp_s[411]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mcc_sp_s[435]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mcc_sp_s[771]=(bbeta*pow(E,yss[8])*Pssp*(1 + yss[5]))/pow(zbar,rrho);
	Mcc_sp_s[4]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mcc_sp_s[28]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mcc_sp_s[52]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mcc_sp_s[76]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mcc_sp_s[100]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mcc_sp_s[124]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mcc_sp_s[148]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mcc_sp_s[172]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mcc_sp_s[340]=-(kkappa*Pssp*yss[9]);
	Mcc_sp_s[388]=pow(E,yss[8])*Pssp;
	Mcc_sp_s[412]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mcc_sp_s[436]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mcc_sp_s[604]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho));
	Mcc_sp_s[628]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho);
	Mcc_sp_s[676]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho));
	Mcc_sp_s[772]=(bbeta*pow(E,yss[8])*Pssp*(-1 + ddelta - abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)))/pow(zbar,rrho);
	Mcc_sp_s[5]=iiota*Pssp*zbar;
	Mcc_sp_s[77]=iiota*Pssp*zbar;
	Mcc_sp_s[341]=-Pssp;
	Mcc_sp_s[222]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mcc_sp_s[366]=-(pow(E,yss[7])*Pssp);
	Mcc_sp_s[414]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mcc_sp_s[438]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mcc_sp_s[31]=-((Pssp*zbar)/(1 + yss[5]));
	Mcc_sp_s[55]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mcc_sp_s[79]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mcc_sp_s[103]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mcc_sp_s[151]=-(pow(E,yss[11])*ebar*Pssp);
	Mcc_sp_s[199]=-(pow(E,yss[0])*Pssp);
	Mcc_sp_s[223]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mcc_sp_s[247]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mcc_sp_s[271]=-(pow(E,yss[3])*Pssp);
	Mcc_sp_s[319]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mcc_sp_s[367]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mcc_sp_s[415]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mcc_sp_s[439]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mcc_sp_s[8]=-(pow(E,xss[0])*Pssp*zbar);
	Mcc_sp_s[80]=-(pow(E,xss[0])*Pssp*zbar);
	Mcc_sp_s[272]=pow(E,yss[3])*Pssp;
	Mcc_sp_s[416]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mcc_sp_s[440]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mcc_sp_s[9]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mcc_sp_s[33]=(Pssp*zbar)/(1 + yss[5]);
	Mcc_sp_s[81]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mcc_sp_s[105]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mcc_sp_s[225]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mcc_sp_s[249]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mcc_sp_s[321]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mcc_sp_s[345]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mcc_sp_s[369]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mcc_sp_s[417]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mcc_sp_s[441]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mcc_sp_s[418]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mcc_sp_s[442]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mcc_sp_s[35]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mcc_sp_s[131]=Pssp;
	Mcc_sp_s[323]=-Pssp;
	Mcc_sp_s[419]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mcc_sp_s[443]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mcc_sp_s[12]=pow(E,xss[0])*Pssp;
	Mcc_sp_s[300]=-(pow(E,xss[0])*Pssp);
	Mcc_sp_s[61]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mcc_sp_s[85]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mcc_sp_s[109]=pow(E,yss[2])*pbar*Pssp;
	Mcc_sp_s[229]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mcc_sp_s[253]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mcc_sp_s[421]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mcc_sp_s[445]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mcc_sp_s[469]=pow(E,yss[11])*Pssp;
	Mcc_sp_s[38]=-((Pssp*zbar)/pow(E,yss[11]));
	Mcc_sp_s[86]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mcc_sp_s[422]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mcc_sp_s[446]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mcc_sp_s[470]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mcc_sp_s[494]=Pssp;
	Mcc_sp_s[39]=-((Pssp*zbar)/pow(E,yss[11]));
	Mcc_sp_s[87]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mcc_sp_s[423]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mcc_sp_s[447]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mcc_sp_s[471]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mcc_sp_s[519]=Pssp;
	Mcc_sp_s[160]=ebar*Pssp;
	Mcc_sp_s[208]=pow(E,yss[0] - yss[11])*Pssp;
	Mcc_sp_s[280]=pow(E,yss[3] - yss[11])*Pssp;
	Mcc_sp_s[424]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mcc_sp_s[448]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mcc_sp_s[472]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mcc_sp_s[544]=Pssp;
	Mcc_sp_s[17]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mcc_sp_s[41]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mcc_sp_s[65]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mcc_sp_s[89]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mcc_sp_s[113]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mcc_sp_s[137]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mcc_sp_s[161]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mcc_sp_s[185]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mcc_sp_s[425]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mcc_sp_s[449]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mcc_sp_s[569]=Pssp;
	Mcc_sp_s[785]=(Pssp*pow(zbar,rrho)*yss[9])/(bbeta*pow(E,yss[8]));
	Mcc_sp_s[66]=-Pssp;
	Mcc_sp_s[91]=-Pssp;
	Mcc_sp_s[116]=-Pssp;
	Mcc_sp_s[189]=-Pssp;
	Mcc_sp_s[166]=-Pssp;
	Mcc_sp_s[143]=-Pssp;
	Ncc_sp_s[0]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*pow(Gs[224],2)) + pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*oomega*Pssp*rrho*pow(Gs[225],2) - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-2 - rrho)*Pssp*(-1 - rrho)*rrho*pow(pow(E,yss[0])*Gs[224] - pow(pow(E,yss[1]),oomega)*Gs[225],2) - pow(E,yss[8])*Pssp*pow(Gs[232],2) - 2*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*(pow(E,yss[0])*Gs[224] - pow(pow(E,yss[1]),oomega)*Gs[225])*Hs[119] + (Pssp*pow(Hs[119],2))/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho) + 2*(dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-(pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho*(pow(E,yss[0])*Gs[224] - pow(pow(E,yss[1]),oomega)*Gs[225])) - pow(E,yss[8])*Gs[232] + Hs[119]/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho));
	Ncc_sp_s[1]=-(pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*pow(Gs[225],2)) + 2*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Gs[226] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*pow(Gs[226],2) - (2*pbar*pphi*Pssp*Gs[229]*Gs[233])/pow(E,yss[8]) - 2*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[114] + 2*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[114] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*pow(Hs[114],2) - 2*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[115] + 2*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[115] - 2*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[114]*Hs[115] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*pow(Hs[115],2) + (2*pbar*pphi*Pssp*Gs[232]*Gs[233]*(1 + yss[5]))/pow(E,yss[8]) + (2*pbar*pphi*Pssp*Gs[229]*Gs[232]*yss[9])/pow(E,yss[8]) - (pbar*pphi*Pssp*pow(Gs[232],2)*(1 + yss[5])*yss[9])/pow(E,yss[8]) - pbar*Pssp*pow(Hs[116],2)*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (2*pbar*pphi*Pssp*Hs[116]*(Gs[229]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[233] - Gs[232]*yss[9])))/pow(E,yss[8]) + 2*(dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[225]) + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*pow(zbar,aalpha)*Gs[226] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[114] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[115] - pbar*Hs[116]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*(Gs[229]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[233] - Gs[232]*yss[9])))/pow(E,yss[8]));
	Ncc_sp_s[2]=-(pow(pow(E,yss[1]),-1 + oomega)*pow(-1 + oomega,2)*Pssp*pow(Gs[225],2)) + pow(-1 + aalpha,2)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*pow(Gs[225],2) - 2*(-1 + aalpha)*aalpha*abar*pow(E,-yss[1] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Gs[226] + aalpha*abar*pow(E,-yss[1] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*pow(Gs[226],2) - 2*pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[229]*Gs[233] + 2*(-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[114] - 2*aalpha*abar*pow(E,-yss[1] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*pow(Hs[114],2) + 2*(-1 + aalpha)*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[115] - 2*pow(aalpha,2)*abar*pow(E,-yss[1] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[115] + 2*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[114]*Hs[115] + pow(aalpha,3)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*pow(Hs[115],2) + 2*pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[232]*Gs[233]*(1 + yss[5]) + 2*pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[229]*Gs[232]*yss[9] - pow(E,yss[7] - yss[8])*pphi*Pssp*pow(Gs[232],2)*(1 + yss[5])*yss[9] - pow(E,yss[7])*pphi*Pssp*pow(Gs[231],2)*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - 2*pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[231]*(Gs[229]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[233] - Gs[232]*yss[9])) + 2*(dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[225]) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[225] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[226] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[114] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[115] - pow(E,yss[7])*pphi*Gs[231]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*(Gs[229]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[233] - Gs[232]*yss[9])));
	Ncc_sp_s[3]=(bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(ssigmazsp,2))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[2056])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[2312])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[2568])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[2824])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[3080])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[3336])/pow(zbar,rrho) - pow(E,yss[8])*Pssp*pow(Gs[232],2) + (2*bbeta*pow(E,yss[8])*Gs[229]*(dP2ssp*Gs[233] + dP1ssp*Gs[234]))/pow(zbar,rrho) - 2*pow(E,yss[8])*Gs[232]*(dP2ssp*Gs[233] + dP1ssp*Gs[234]) + 2*Gs[233]*(dP2ssp*Gs[233] + dP1ssp*Gs[234]) + (bbeta*pow(E,yss[8])*Pssp*pow(Gsp[136],2))/pow(zbar,rrho) - (2*bbeta*pow(E,yss[8])*Pssp*rrho*ssigmazsp*Gsp[152])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*pow(Gsp[152],2))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*pow(Gsp[168],2))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*pow(Gsp[184],2))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*pow(Gsp[200],2))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*pow(Gsp[216],2))/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*Pssp*Gs[229]*Gsp[232])/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*Pssp*Gs[229]*Gsp[8]*Hs[112])/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*Pssp*Gs[229]*Gsp[24]*Hs[113])/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*Pssp*Gs[229]*Gsp[40]*Hs[114])/pow(zbar,rrho) - (2*bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gs[229]*Hs[115])/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*Pssp*Gs[229]*Gsp[56]*Hs[115])/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*Pssp*Gs[229]*Gsp[72]*Hs[116])/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*Pssp*Gs[229]*Gsp[88]*Hs[117])/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*Pssp*Gs[229]*Gsp[104]*Hs[118])/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*Pssp*Gs[229]*Gsp[120]*Hs[119])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(ssigmazsp,2)*yss[5])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[2056]*yss[5])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[2312]*yss[5])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[2568]*yss[5])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[2824]*yss[5])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[3080]*yss[5])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[3336]*yss[5])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*pow(Gsp[136],2)*yss[5])/pow(zbar,rrho) - (2*bbeta*pow(E,yss[8])*Pssp*rrho*ssigmazsp*Gsp[152]*yss[5])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*pow(Gsp[152],2)*yss[5])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*pow(Gsp[168],2)*yss[5])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*pow(Gsp[184],2)*yss[5])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*pow(Gsp[200],2)*yss[5])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*pow(Gsp[216],2)*yss[5])/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*(dP2ssp*Gs[233] + dP1ssp*Gs[234])*Gsp[232]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*pow(Gsp[232],2)*(1 + yss[5]))/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*Pssp*G2sp[232]*Hs[112]*(1 + yss[5]))/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*(dP2ssp*Gs[233] + dP1ssp*Gs[234])*Gsp[8]*Hs[112]*(1 + yss[5]))/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*Pssp*Gsp[8]*Gsp[232]*Hs[112]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[8]*pow(Hs[112],2)*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*pow(Gsp[8],2)*pow(Hs[112],2)*(1 + yss[5]))/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*Pssp*G2sp[472]*Hs[113]*(1 + yss[5]))/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*(dP2ssp*Gs[233] + dP1ssp*Gs[234])*Gsp[24]*Hs[113]*(1 + yss[5]))/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*Pssp*Gsp[24]*Gsp[232]*Hs[113]*(1 + yss[5]))/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*Pssp*G2sp[24]*Hs[112]*Hs[113]*(1 + yss[5]))/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*Pssp*Gsp[8]*Gsp[24]*Hs[112]*Hs[113]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[264]*pow(Hs[113],2)*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*pow(Gsp[24],2)*pow(Hs[113],2)*(1 + yss[5]))/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*Pssp*G2sp[712]*Hs[114]*(1 + yss[5]))/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*(dP2ssp*Gs[233] + dP1ssp*Gs[234])*Gsp[40]*Hs[114]*(1 + yss[5]))/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*Pssp*Gsp[40]*Gsp[232]*Hs[114]*(1 + yss[5]))/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*Pssp*G2sp[40]*Hs[112]*Hs[114]*(1 + yss[5]))/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*Pssp*Gsp[8]*Gsp[40]*Hs[112]*Hs[114]*(1 + yss[5]))/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*Pssp*G2sp[280]*Hs[113]*Hs[114]*(1 + yss[5]))/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*Pssp*Gsp[24]*Gsp[40]*Hs[113]*Hs[114]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[520]*pow(Hs[114],2)*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*pow(Gsp[40],2)*pow(Hs[114],2)*(1 + yss[5]))/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*Pssp*G2sp[952]*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) - (2*bbeta*pow(E,yss[8])*rrho*rrhoz*(dP2ssp*Gs[233] + dP1ssp*Gs[234])*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*(dP2ssp*Gs[233] + dP1ssp*Gs[234])*Gsp[56]*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) - (2*bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gsp[232]*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*Pssp*Gsp[56]*Gsp[232]*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*Pssp*G2sp[56]*Hs[112]*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) - (2*bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gsp[8]*Hs[112]*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*Pssp*Gsp[8]*Gsp[56]*Hs[112]*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*Pssp*G2sp[296]*Hs[113]*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) - (2*bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gsp[24]*Hs[113]*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*Pssp*Gsp[24]*Gsp[56]*Hs[113]*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*Pssp*G2sp[536]*Hs[114]*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) - (2*bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gsp[40]*Hs[114]*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*Pssp*Gsp[40]*Gsp[56]*Hs[114]*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*pow(Hs[115],2)*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[776]*pow(Hs[115],2)*(1 + yss[5]))/pow(zbar,rrho) - (2*bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gsp[56]*pow(Hs[115],2)*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*pow(Gsp[56],2)*pow(Hs[115],2)*(1 + yss[5]))/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*Pssp*G2sp[1192]*Hs[116]*(1 + yss[5]))/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*(dP2ssp*Gs[233] + dP1ssp*Gs[234])*Gsp[72]*Hs[116]*(1 + yss[5]))/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*Pssp*Gsp[72]*Gsp[232]*Hs[116]*(1 + yss[5]))/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*Pssp*G2sp[72]*Hs[112]*Hs[116]*(1 + yss[5]))/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*Pssp*Gsp[8]*Gsp[72]*Hs[112]*Hs[116]*(1 + yss[5]))/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*Pssp*G2sp[312]*Hs[113]*Hs[116]*(1 + yss[5]))/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*Pssp*Gsp[24]*Gsp[72]*Hs[113]*Hs[116]*(1 + yss[5]))/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*Pssp*G2sp[552]*Hs[114]*Hs[116]*(1 + yss[5]))/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*Pssp*Gsp[40]*Gsp[72]*Hs[114]*Hs[116]*(1 + yss[5]))/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*Pssp*G2sp[792]*Hs[115]*Hs[116]*(1 + yss[5]))/pow(zbar,rrho) - (2*bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gsp[72]*Hs[115]*Hs[116]*(1 + yss[5]))/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*Pssp*Gsp[56]*Gsp[72]*Hs[115]*Hs[116]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1032]*pow(Hs[116],2)*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*pow(Gsp[72],2)*pow(Hs[116],2)*(1 + yss[5]))/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*Pssp*G2sp[1432]*Hs[117]*(1 + yss[5]))/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*(dP2ssp*Gs[233] + dP1ssp*Gs[234])*Gsp[88]*Hs[117]*(1 + yss[5]))/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*Pssp*Gsp[88]*Gsp[232]*Hs[117]*(1 + yss[5]))/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*Pssp*G2sp[88]*Hs[112]*Hs[117]*(1 + yss[5]))/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*Pssp*Gsp[8]*Gsp[88]*Hs[112]*Hs[117]*(1 + yss[5]))/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*Pssp*G2sp[328]*Hs[113]*Hs[117]*(1 + yss[5]))/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*Pssp*Gsp[24]*Gsp[88]*Hs[113]*Hs[117]*(1 + yss[5]))/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*Pssp*G2sp[568]*Hs[114]*Hs[117]*(1 + yss[5]))/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*Pssp*Gsp[40]*Gsp[88]*Hs[114]*Hs[117]*(1 + yss[5]))/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*Pssp*G2sp[808]*Hs[115]*Hs[117]*(1 + yss[5]))/pow(zbar,rrho) - (2*bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gsp[88]*Hs[115]*Hs[117]*(1 + yss[5]))/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*Pssp*Gsp[56]*Gsp[88]*Hs[115]*Hs[117]*(1 + yss[5]))/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*Pssp*G2sp[1048]*Hs[116]*Hs[117]*(1 + yss[5]))/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*Pssp*Gsp[72]*Gsp[88]*Hs[116]*Hs[117]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1288]*pow(Hs[117],2)*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*pow(Gsp[88],2)*pow(Hs[117],2)*(1 + yss[5]))/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*Pssp*G2sp[1672]*Hs[118]*(1 + yss[5]))/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*(dP2ssp*Gs[233] + dP1ssp*Gs[234])*Gsp[104]*Hs[118]*(1 + yss[5]))/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*Pssp*Gsp[104]*Gsp[232]*Hs[118]*(1 + yss[5]))/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*Pssp*G2sp[104]*Hs[112]*Hs[118]*(1 + yss[5]))/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*Pssp*Gsp[8]*Gsp[104]*Hs[112]*Hs[118]*(1 + yss[5]))/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*Pssp*G2sp[344]*Hs[113]*Hs[118]*(1 + yss[5]))/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*Pssp*Gsp[24]*Gsp[104]*Hs[113]*Hs[118]*(1 + yss[5]))/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*Pssp*G2sp[584]*Hs[114]*Hs[118]*(1 + yss[5]))/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*Pssp*Gsp[40]*Gsp[104]*Hs[114]*Hs[118]*(1 + yss[5]))/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*Pssp*G2sp[824]*Hs[115]*Hs[118]*(1 + yss[5]))/pow(zbar,rrho) - (2*bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gsp[104]*Hs[115]*Hs[118]*(1 + yss[5]))/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*Pssp*Gsp[56]*Gsp[104]*Hs[115]*Hs[118]*(1 + yss[5]))/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*Pssp*G2sp[1064]*Hs[116]*Hs[118]*(1 + yss[5]))/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*Pssp*Gsp[72]*Gsp[104]*Hs[116]*Hs[118]*(1 + yss[5]))/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*Pssp*G2sp[1304]*Hs[117]*Hs[118]*(1 + yss[5]))/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*Pssp*Gsp[88]*Gsp[104]*Hs[117]*Hs[118]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1544]*pow(Hs[118],2)*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*pow(Gsp[104],2)*pow(Hs[118],2)*(1 + yss[5]))/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*Pssp*G2sp[1912]*Hs[119]*(1 + yss[5]))/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*(dP2ssp*Gs[233] + dP1ssp*Gs[234])*Gsp[120]*Hs[119]*(1 + yss[5]))/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*Pssp*Gsp[120]*Gsp[232]*Hs[119]*(1 + yss[5]))/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*Pssp*G2sp[120]*Hs[112]*Hs[119]*(1 + yss[5]))/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*Pssp*Gsp[8]*Gsp[120]*Hs[112]*Hs[119]*(1 + yss[5]))/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*Pssp*G2sp[360]*Hs[113]*Hs[119]*(1 + yss[5]))/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*Pssp*Gsp[24]*Gsp[120]*Hs[113]*Hs[119]*(1 + yss[5]))/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*Pssp*G2sp[600]*Hs[114]*Hs[119]*(1 + yss[5]))/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*Pssp*Gsp[40]*Gsp[120]*Hs[114]*Hs[119]*(1 + yss[5]))/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*Pssp*G2sp[840]*Hs[115]*Hs[119]*(1 + yss[5]))/pow(zbar,rrho) - (2*bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gsp[120]*Hs[115]*Hs[119]*(1 + yss[5]))/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*Pssp*Gsp[56]*Gsp[120]*Hs[115]*Hs[119]*(1 + yss[5]))/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*Pssp*G2sp[1080]*Hs[116]*Hs[119]*(1 + yss[5]))/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*Pssp*Gsp[72]*Gsp[120]*Hs[116]*Hs[119]*(1 + yss[5]))/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*Pssp*G2sp[1320]*Hs[117]*Hs[119]*(1 + yss[5]))/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*Pssp*Gsp[88]*Gsp[120]*Hs[117]*Hs[119]*(1 + yss[5]))/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*Pssp*G2sp[1560]*Hs[118]*Hs[119]*(1 + yss[5]))/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*Pssp*Gsp[104]*Gsp[120]*Hs[118]*Hs[119]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1800]*pow(Hs[119],2)*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*pow(Gsp[120],2)*pow(Hs[119],2)*(1 + yss[5]))/pow(zbar,rrho);
	Ncc_sp_s[4]=(pow(pow(E,yss[2]),-aalpha - eeta)*(-2*(dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-(pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*pow(zbar,rrho)*Gs[232]) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*kkappa*pow(zbar,rrho)*Gs[233] + aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[225] + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[226] - aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[226] - abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[226] + bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[228] + bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[232] - bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[232] + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[232] - bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Hs[112] - abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Hs[112] + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Hs[112] - pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho)*Hs[112] + aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1]*Hs[112] + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2]*Hs[112] - aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2]*Hs[112] - abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2]*Hs[112] + bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4]*Hs[112] + bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8]*Hs[112] - bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8]*Hs[112] + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]*Hs[112] + aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17]*Hs[113] + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18]*Hs[113] - aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18]*Hs[113] - abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18]*Hs[113] + bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20]*Hs[113] + bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24]*Hs[113] - bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24]*Hs[113] + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]*Hs[113] - bbeta*pow(E,yss[8])*(-(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha)) - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40])*Hs[114] - bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz*Hs[115] + bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz*Hs[115] + bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2)*Hs[115] + aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha)*Hs[115] - abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha)*Hs[115] - pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho)*Hs[115] + aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49]*Hs[115] + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50]*Hs[115] - aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50]*Hs[115] - abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50]*Hs[115] + bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52]*Hs[115] + bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56]*Hs[115] - bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56]*Hs[115] + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]*Hs[115] + aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65]*Hs[116] + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66]*Hs[116] - aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66]*Hs[116] - abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66]*Hs[116] + bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68]*Hs[116] + bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72]*Hs[116] - bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72]*Hs[116] + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]*Hs[116] + aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81]*Hs[117] + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82]*Hs[117] - aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82]*Hs[117] - abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82]*Hs[117] + bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84]*Hs[117] + bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88]*Hs[117] - bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88]*Hs[117] + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]*Hs[117] + aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97]*Hs[118] + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98]*Hs[118] - aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98]*Hs[118] - abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98]*Hs[118] + bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100]*Hs[118] + bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104]*Hs[118] - bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104]*Hs[118] + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]*Hs[118] + aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113]*Hs[119] + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114]*Hs[119] - aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114]*Hs[119] - abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114]*Hs[119] + bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116]*Hs[119] + bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120]*Hs[119] - bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120]*Hs[119] + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]*Hs[119] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*kkappa*pow(zbar,rrho)*Gs[230]*yss[9]) - Pssp*(abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(ssigmaasp,2)*pow(zbar,aalpha) - bbeta*pow(E,yss[8])*pow(ssigmazsp,2)*(-(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(aalpha - rrho,2)*pow(zbar,aalpha)) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*((-1 + ddelta)*pow(rrho,2) - 2*iiota*pow(zbar,2) + 2*iiota*rrho*pow(zbar,2))) + aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[2049] + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[2050] - aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[2050] - abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*G2sp[2050] + bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*G2sp[2052] + bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[2056] - bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[2056] + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[2056] + aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[2305] + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[2306] - aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[2306] - abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*G2sp[2306] + bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*G2sp[2308] + bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[2312] - bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[2312] + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[2312] + aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[2561] + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[2562] - aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[2562] - abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*G2sp[2562] + bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*G2sp[2564] + bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[2568] - bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[2568] + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[2568] + aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[2817] + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[2818] - aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[2818] - abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*G2sp[2818] + bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*G2sp[2820] + bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[2824] - bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[2824] + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[2824] + aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[3073] + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[3074] - aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[3074] - abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*G2sp[3074] + bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*G2sp[3076] + bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[3080] - bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[3080] + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[3080] + aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[3329] + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[3330] - aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[3330] - abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*G2sp[3330] + bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*G2sp[3332] + bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[3336] - bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[3336] + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[3336] - pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*pow(zbar,rrho)*pow(Gs[232],2) + 2*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*kkappa*pow(zbar,rrho)*Gs[230]*Gs[233] + pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*pow(Gsp[129],2) + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[129]*Gsp[130] - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[129]*Gsp[130] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[129]*Gsp[130] + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*pow(Gsp[130],2) - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*pow(Gsp[130],2) + pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*pow(Gsp[130],2) - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*pow(Gsp[130],2) + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*pow(Gsp[130],2) + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,3)*pow(zbar,aalpha)*pow(Gsp[130],2) + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*pow(Gsp[132],2) + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[129]*Gsp[136] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[130]*Gsp[136] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[130]*Gsp[136] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[130]*Gsp[136] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[132]*Gsp[136] + bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*pow(Gsp[136],2) - bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*pow(Gsp[136],2) + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*pow(Gsp[136],2) + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*ssigmaasp*pow(zbar,aalpha)*(aalpha*Gsp[129] - (-1 + aalpha + eeta)*Gsp[130] + Gsp[136]) + pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*pow(Gsp[145],2) + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[145]*Gsp[146] - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[145]*Gsp[146] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[145]*Gsp[146] + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*pow(Gsp[146],2) - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*pow(Gsp[146],2) + pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*pow(Gsp[146],2) - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*pow(Gsp[146],2) + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*pow(Gsp[146],2) + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,3)*pow(zbar,aalpha)*pow(Gsp[146],2) + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*pow(Gsp[148],2) + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[145]*Gsp[152] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[146]*Gsp[152] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[146]*Gsp[152] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[146]*Gsp[152] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[148]*Gsp[152] + bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*pow(Gsp[152],2) - bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*pow(Gsp[152],2) + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*pow(Gsp[152],2) + 2*bbeta*pow(E,yss[8])*ssigmazsp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*(aalpha - rrho)*pow(zbar,aalpha)*Gsp[145] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[146] - pow(aalpha,2)*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[146] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[146] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*pow(zbar,aalpha)*Gsp[146] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*pow(zbar,aalpha)*Gsp[146] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*rrho*pow(zbar,aalpha)*Gsp[146] - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*(-2 + rrho)*pow(zbar,2)*Gsp[148] - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*Gsp[152] + ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*Gsp[152] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[152] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[152] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*pow(zbar,aalpha)*Gsp[152]) + pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*pow(Gsp[161],2) + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[161]*Gsp[162] - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[161]*Gsp[162] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[161]*Gsp[162] + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*pow(Gsp[162],2) - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*pow(Gsp[162],2) + pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*pow(Gsp[162],2) - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*pow(Gsp[162],2) + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*pow(Gsp[162],2) + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,3)*pow(zbar,aalpha)*pow(Gsp[162],2) + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*pow(Gsp[164],2) + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[161]*Gsp[168] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[162]*Gsp[168] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[162]*Gsp[168] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[162]*Gsp[168] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[164]*Gsp[168] + bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*pow(Gsp[168],2) - bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*pow(Gsp[168],2) + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*pow(Gsp[168],2) + pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*pow(Gsp[177],2) + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[177]*Gsp[178] - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[177]*Gsp[178] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[177]*Gsp[178] + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*pow(Gsp[178],2) - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*pow(Gsp[178],2) + pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*pow(Gsp[178],2) - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*pow(Gsp[178],2) + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*pow(Gsp[178],2) + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,3)*pow(zbar,aalpha)*pow(Gsp[178],2) + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*pow(Gsp[180],2) + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[177]*Gsp[184] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[178]*Gsp[184] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[178]*Gsp[184] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[178]*Gsp[184] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[180]*Gsp[184] + bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*pow(Gsp[184],2) - bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*pow(Gsp[184],2) + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*pow(Gsp[184],2) + pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*pow(Gsp[193],2) + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[193]*Gsp[194] - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[193]*Gsp[194] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[193]*Gsp[194] + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*pow(Gsp[194],2) - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*pow(Gsp[194],2) + pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*pow(Gsp[194],2) - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*pow(Gsp[194],2) + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*pow(Gsp[194],2) + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,3)*pow(zbar,aalpha)*pow(Gsp[194],2) + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*pow(Gsp[196],2) + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[193]*Gsp[200] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[194]*Gsp[200] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[194]*Gsp[200] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[194]*Gsp[200] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[196]*Gsp[200] + bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*pow(Gsp[200],2) - bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*pow(Gsp[200],2) + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*pow(Gsp[200],2) + pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*pow(Gsp[209],2) + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[209]*Gsp[210] - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[209]*Gsp[210] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[209]*Gsp[210] + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*pow(Gsp[210],2) - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*pow(Gsp[210],2) + pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*pow(Gsp[210],2) - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*pow(Gsp[210],2) + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*pow(Gsp[210],2) + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,3)*pow(zbar,aalpha)*pow(Gsp[210],2) + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*pow(Gsp[212],2) + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[209]*Gsp[216] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[210]*Gsp[216] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[210]*Gsp[216] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[210]*Gsp[216] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[212]*Gsp[216] + bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*pow(Gsp[216],2) - bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*pow(Gsp[216],2) + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*pow(Gsp[216],2) + pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*pow(Gsp[225],2) + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[225]*Gsp[226] - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[225]*Gsp[226] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[225]*Gsp[226] + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*pow(Gsp[226],2) - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*pow(Gsp[226],2) + pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*pow(Gsp[226],2) - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*pow(Gsp[226],2) + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*pow(Gsp[226],2) + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,3)*pow(zbar,aalpha)*pow(Gsp[226],2) + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*pow(Gsp[228],2) + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[225]*Gsp[232] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[226]*Gsp[232] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[226]*Gsp[232] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[226]*Gsp[232] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[228]*Gsp[232] + bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*pow(Gsp[232],2) - bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*pow(Gsp[232],2) + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*pow(Gsp[232],2) + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[225]*Hs[112] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[226]*Hs[112] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[226]*Hs[112] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*G2sp[226]*Hs[112] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*G2sp[228]*Hs[112] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[232]*Hs[112] - 2*bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[232]*Hs[112] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[232]*Hs[112] - 2*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho)*Gs[232]*Hs[112] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[225]*Hs[112] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[225]*Hs[112] + 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1]*Gsp[225]*Hs[112] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2]*Gsp[225]*Hs[112] - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2]*Gsp[225]*Hs[112] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2]*Gsp[225]*Hs[112] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]*Gsp[225]*Hs[112] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[226]*Hs[112] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[226]*Hs[112] + 4*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[226]*Hs[112] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[226]*Hs[112] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,3)*pow(zbar,aalpha)*Gsp[226]*Hs[112] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1]*Gsp[226]*Hs[112] - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1]*Gsp[226]*Hs[112] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[1]*Gsp[226]*Hs[112] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2]*Gsp[226]*Hs[112] - 4*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2]*Gsp[226]*Hs[112] + 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2]*Gsp[226]*Hs[112] - 4*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2]*Gsp[226]*Hs[112] + 4*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2]*Gsp[226]*Hs[112] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,3)*pow(zbar,aalpha)*Gsp[2]*Gsp[226]*Hs[112] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]*Gsp[226]*Hs[112] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]*Gsp[226]*Hs[112] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[8]*Gsp[226]*Hs[112] - 4*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[228]*Hs[112] + 4*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4]*Gsp[228]*Hs[112] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[8]*Gsp[228]*Hs[112] - 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[232]*Hs[112] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[232]*Hs[112] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[232]*Hs[112] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1]*Gsp[232]*Hs[112] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2]*Gsp[232]*Hs[112] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2]*Gsp[232]*Hs[112] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2]*Gsp[232]*Hs[112] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4]*Gsp[232]*Hs[112] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8]*Gsp[232]*Hs[112] - 2*bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8]*Gsp[232]*Hs[112] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]*Gsp[232]*Hs[112] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*pow(Hs[112],2) + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*pow(Hs[112],2) - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*pow(Hs[112],2) + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,3)*pow(zbar,aalpha)*pow(Hs[112],2) - pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho)*pow(Hs[112],2) + aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[1]*pow(Hs[112],2) + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[2]*pow(Hs[112],2) - aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[2]*pow(Hs[112],2) - abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*G2sp[2]*pow(Hs[112],2) + bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*G2sp[4]*pow(Hs[112],2) + bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[8]*pow(Hs[112],2) - bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[8]*pow(Hs[112],2) + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[8]*pow(Hs[112],2) - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1]*pow(Hs[112],2) + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[1]*pow(Hs[112],2) + pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*pow(Gsp[1],2)*pow(Hs[112],2) - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2]*pow(Hs[112],2) + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2]*pow(Hs[112],2) + 4*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2]*pow(Hs[112],2) - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2]*pow(Hs[112],2) - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,3)*pow(zbar,aalpha)*Gsp[2]*pow(Hs[112],2) + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1]*Gsp[2]*pow(Hs[112],2) - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1]*Gsp[2]*pow(Hs[112],2) - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[1]*Gsp[2]*pow(Hs[112],2) + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*pow(Gsp[2],2)*pow(Hs[112],2) - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*pow(Gsp[2],2)*pow(Hs[112],2) + pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*pow(Gsp[2],2)*pow(Hs[112],2) - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*pow(Gsp[2],2)*pow(Hs[112],2) + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*pow(Gsp[2],2)*pow(Hs[112],2) + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,3)*pow(zbar,aalpha)*pow(Gsp[2],2)*pow(Hs[112],2) - 4*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4]*pow(Hs[112],2) + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*pow(Gsp[4],2)*pow(Hs[112],2) - 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[8]*pow(Hs[112],2) - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]*pow(Hs[112],2) + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[8]*pow(Hs[112],2) + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1]*Gsp[8]*pow(Hs[112],2) + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2]*Gsp[8]*pow(Hs[112],2) - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2]*Gsp[8]*pow(Hs[112],2) - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2]*Gsp[8]*pow(Hs[112],2) + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4]*Gsp[8]*pow(Hs[112],2) + bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*pow(Gsp[8],2)*pow(Hs[112],2) - bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*pow(Gsp[8],2)*pow(Hs[112],2) + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*pow(Gsp[8],2)*pow(Hs[112],2) + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[465]*Hs[113] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[466]*Hs[113] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[466]*Hs[113] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*G2sp[466]*Hs[113] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*G2sp[468]*Hs[113] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[472]*Hs[113] - 2*bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[472]*Hs[113] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[472]*Hs[113] + 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17]*Gsp[225]*Hs[113] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18]*Gsp[225]*Hs[113] - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18]*Gsp[225]*Hs[113] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18]*Gsp[225]*Hs[113] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]*Gsp[225]*Hs[113] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17]*Gsp[226]*Hs[113] - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17]*Gsp[226]*Hs[113] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[17]*Gsp[226]*Hs[113] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18]*Gsp[226]*Hs[113] - 4*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18]*Gsp[226]*Hs[113] + 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18]*Gsp[226]*Hs[113] - 4*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18]*Gsp[226]*Hs[113] + 4*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18]*Gsp[226]*Hs[113] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,3)*pow(zbar,aalpha)*Gsp[18]*Gsp[226]*Hs[113] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]*Gsp[226]*Hs[113] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]*Gsp[226]*Hs[113] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[24]*Gsp[226]*Hs[113] + 4*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20]*Gsp[228]*Hs[113] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[24]*Gsp[228]*Hs[113] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17]*Gsp[232]*Hs[113] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18]*Gsp[232]*Hs[113] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18]*Gsp[232]*Hs[113] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18]*Gsp[232]*Hs[113] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20]*Gsp[232]*Hs[113] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24]*Gsp[232]*Hs[113] - 2*bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24]*Gsp[232]*Hs[113] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]*Gsp[232]*Hs[113] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[17]*Hs[112]*Hs[113] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[18]*Hs[112]*Hs[113] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[18]*Hs[112]*Hs[113] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*G2sp[18]*Hs[112]*Hs[113] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*G2sp[20]*Hs[112]*Hs[113] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[24]*Hs[112]*Hs[113] - 2*bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[24]*Hs[112]*Hs[113] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[24]*Hs[112]*Hs[113] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17]*Hs[112]*Hs[113] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[17]*Hs[112]*Hs[113] + 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1]*Gsp[17]*Hs[112]*Hs[113] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2]*Gsp[17]*Hs[112]*Hs[113] - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2]*Gsp[17]*Hs[112]*Hs[113] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2]*Gsp[17]*Hs[112]*Hs[113] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]*Gsp[17]*Hs[112]*Hs[113] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18]*Hs[112]*Hs[113] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18]*Hs[112]*Hs[113] + 4*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18]*Hs[112]*Hs[113] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18]*Hs[112]*Hs[113] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,3)*pow(zbar,aalpha)*Gsp[18]*Hs[112]*Hs[113] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1]*Gsp[18]*Hs[112]*Hs[113] - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1]*Gsp[18]*Hs[112]*Hs[113] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[1]*Gsp[18]*Hs[112]*Hs[113] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2]*Gsp[18]*Hs[112]*Hs[113] - 4*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2]*Gsp[18]*Hs[112]*Hs[113] + 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2]*Gsp[18]*Hs[112]*Hs[113] - 4*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2]*Gsp[18]*Hs[112]*Hs[113] + 4*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2]*Gsp[18]*Hs[112]*Hs[113] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,3)*pow(zbar,aalpha)*Gsp[2]*Gsp[18]*Hs[112]*Hs[113] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]*Gsp[18]*Hs[112]*Hs[113] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]*Gsp[18]*Hs[112]*Hs[113] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[8]*Gsp[18]*Hs[112]*Hs[113] - 4*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20]*Hs[112]*Hs[113] + 4*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4]*Gsp[20]*Hs[112]*Hs[113] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[8]*Gsp[20]*Hs[112]*Hs[113] - 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[24]*Hs[112]*Hs[113] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]*Hs[112]*Hs[113] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[24]*Hs[112]*Hs[113] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1]*Gsp[24]*Hs[112]*Hs[113] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2]*Gsp[24]*Hs[112]*Hs[113] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2]*Gsp[24]*Hs[112]*Hs[113] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2]*Gsp[24]*Hs[112]*Hs[113] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4]*Gsp[24]*Hs[112]*Hs[113] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8]*Gsp[24]*Hs[112]*Hs[113] - 2*bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8]*Gsp[24]*Hs[112]*Hs[113] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]*Gsp[24]*Hs[112]*Hs[113] + aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[257]*pow(Hs[113],2) + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[258]*pow(Hs[113],2) - aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[258]*pow(Hs[113],2) - abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*G2sp[258]*pow(Hs[113],2) + bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*G2sp[260]*pow(Hs[113],2) + bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[264]*pow(Hs[113],2) - bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[264]*pow(Hs[113],2) + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[264]*pow(Hs[113],2) + pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*pow(Gsp[17],2)*pow(Hs[113],2) + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17]*Gsp[18]*pow(Hs[113],2) - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17]*Gsp[18]*pow(Hs[113],2) - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[17]*Gsp[18]*pow(Hs[113],2) + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*pow(Gsp[18],2)*pow(Hs[113],2) - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*pow(Gsp[18],2)*pow(Hs[113],2) + pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*pow(Gsp[18],2)*pow(Hs[113],2) - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*pow(Gsp[18],2)*pow(Hs[113],2) + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*pow(Gsp[18],2)*pow(Hs[113],2) + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,3)*pow(zbar,aalpha)*pow(Gsp[18],2)*pow(Hs[113],2) + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*pow(Gsp[20],2)*pow(Hs[113],2) + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17]*Gsp[24]*pow(Hs[113],2) + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18]*Gsp[24]*pow(Hs[113],2) - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18]*Gsp[24]*pow(Hs[113],2) - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18]*Gsp[24]*pow(Hs[113],2) + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20]*Gsp[24]*pow(Hs[113],2) + bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*pow(Gsp[24],2)*pow(Hs[113],2) - bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*pow(Gsp[24],2)*pow(Hs[113],2) + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*pow(Gsp[24],2)*pow(Hs[113],2) + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[705]*Hs[114] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[706]*Hs[114] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[706]*Hs[114] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*G2sp[706]*Hs[114] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*G2sp[708]*Hs[114] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[712]*Hs[114] - 2*bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[712]*Hs[114] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[712]*Hs[114] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha)*Gsp[225]*Hs[114] + 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33]*Gsp[225]*Hs[114] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34]*Gsp[225]*Hs[114] - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34]*Gsp[225]*Hs[114] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34]*Gsp[225]*Hs[114] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]*Gsp[225]*Hs[114] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha)*Gsp[226]*Hs[114] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha)*Gsp[226]*Hs[114] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*rrhoa*pow(zbar,aalpha)*Gsp[226]*Hs[114] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33]*Gsp[226]*Hs[114] - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33]*Gsp[226]*Hs[114] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[33]*Gsp[226]*Hs[114] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34]*Gsp[226]*Hs[114] - 4*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34]*Gsp[226]*Hs[114] + 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34]*Gsp[226]*Hs[114] - 4*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34]*Gsp[226]*Hs[114] + 4*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34]*Gsp[226]*Hs[114] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,3)*pow(zbar,aalpha)*Gsp[34]*Gsp[226]*Hs[114] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]*Gsp[226]*Hs[114] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]*Gsp[226]*Hs[114] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[40]*Gsp[226]*Hs[114] + 4*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36]*Gsp[228]*Hs[114] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[40]*Gsp[228]*Hs[114] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha)*Gsp[232]*Hs[114] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33]*Gsp[232]*Hs[114] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34]*Gsp[232]*Hs[114] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34]*Gsp[232]*Hs[114] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34]*Gsp[232]*Hs[114] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36]*Gsp[232]*Hs[114] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40]*Gsp[232]*Hs[114] - 2*bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40]*Gsp[232]*Hs[114] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]*Gsp[232]*Hs[114] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha)*Hs[112]*Hs[114] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*rrhoa*pow(zbar,aalpha)*Hs[112]*Hs[114] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[33]*Hs[112]*Hs[114] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[34]*Hs[112]*Hs[114] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[34]*Hs[112]*Hs[114] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*G2sp[34]*Hs[112]*Hs[114] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*G2sp[36]*Hs[112]*Hs[114] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[40]*Hs[112]*Hs[114] - 2*bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[40]*Hs[112]*Hs[114] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[40]*Hs[112]*Hs[114] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha)*Gsp[1]*Hs[112]*Hs[114] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha)*Gsp[2]*Hs[112]*Hs[114] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha)*Gsp[2]*Hs[112]*Hs[114] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*rrhoa*pow(zbar,aalpha)*Gsp[2]*Hs[112]*Hs[114] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha)*Gsp[8]*Hs[112]*Hs[114] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33]*Hs[112]*Hs[114] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[33]*Hs[112]*Hs[114] + 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1]*Gsp[33]*Hs[112]*Hs[114] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2]*Gsp[33]*Hs[112]*Hs[114] - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2]*Gsp[33]*Hs[112]*Hs[114] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2]*Gsp[33]*Hs[112]*Hs[114] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]*Gsp[33]*Hs[112]*Hs[114] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34]*Hs[112]*Hs[114] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34]*Hs[112]*Hs[114] + 4*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34]*Hs[112]*Hs[114] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34]*Hs[112]*Hs[114] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,3)*pow(zbar,aalpha)*Gsp[34]*Hs[112]*Hs[114] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1]*Gsp[34]*Hs[112]*Hs[114] - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1]*Gsp[34]*Hs[112]*Hs[114] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[1]*Gsp[34]*Hs[112]*Hs[114] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2]*Gsp[34]*Hs[112]*Hs[114] - 4*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2]*Gsp[34]*Hs[112]*Hs[114] + 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2]*Gsp[34]*Hs[112]*Hs[114] - 4*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2]*Gsp[34]*Hs[112]*Hs[114] + 4*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2]*Gsp[34]*Hs[112]*Hs[114] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,3)*pow(zbar,aalpha)*Gsp[2]*Gsp[34]*Hs[112]*Hs[114] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]*Gsp[34]*Hs[112]*Hs[114] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]*Gsp[34]*Hs[112]*Hs[114] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[8]*Gsp[34]*Hs[112]*Hs[114] - 4*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36]*Hs[112]*Hs[114] + 4*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4]*Gsp[36]*Hs[112]*Hs[114] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[8]*Gsp[36]*Hs[112]*Hs[114] - 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[40]*Hs[112]*Hs[114] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]*Hs[112]*Hs[114] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[40]*Hs[112]*Hs[114] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1]*Gsp[40]*Hs[112]*Hs[114] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2]*Gsp[40]*Hs[112]*Hs[114] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2]*Gsp[40]*Hs[112]*Hs[114] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2]*Gsp[40]*Hs[112]*Hs[114] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4]*Gsp[40]*Hs[112]*Hs[114] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8]*Gsp[40]*Hs[112]*Hs[114] - 2*bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8]*Gsp[40]*Hs[112]*Hs[114] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]*Gsp[40]*Hs[112]*Hs[114] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[273]*Hs[113]*Hs[114] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[274]*Hs[113]*Hs[114] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[274]*Hs[113]*Hs[114] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*G2sp[274]*Hs[113]*Hs[114] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*G2sp[276]*Hs[113]*Hs[114] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[280]*Hs[113]*Hs[114] - 2*bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[280]*Hs[113]*Hs[114] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[280]*Hs[113]*Hs[114] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha)*Gsp[17]*Hs[113]*Hs[114] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha)*Gsp[18]*Hs[113]*Hs[114] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha)*Gsp[18]*Hs[113]*Hs[114] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*rrhoa*pow(zbar,aalpha)*Gsp[18]*Hs[113]*Hs[114] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha)*Gsp[24]*Hs[113]*Hs[114] + 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17]*Gsp[33]*Hs[113]*Hs[114] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18]*Gsp[33]*Hs[113]*Hs[114] - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18]*Gsp[33]*Hs[113]*Hs[114] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18]*Gsp[33]*Hs[113]*Hs[114] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]*Gsp[33]*Hs[113]*Hs[114] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17]*Gsp[34]*Hs[113]*Hs[114] - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17]*Gsp[34]*Hs[113]*Hs[114] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[17]*Gsp[34]*Hs[113]*Hs[114] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18]*Gsp[34]*Hs[113]*Hs[114] - 4*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18]*Gsp[34]*Hs[113]*Hs[114] + 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18]*Gsp[34]*Hs[113]*Hs[114] - 4*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18]*Gsp[34]*Hs[113]*Hs[114] + 4*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18]*Gsp[34]*Hs[113]*Hs[114] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,3)*pow(zbar,aalpha)*Gsp[18]*Gsp[34]*Hs[113]*Hs[114] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]*Gsp[34]*Hs[113]*Hs[114] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]*Gsp[34]*Hs[113]*Hs[114] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[24]*Gsp[34]*Hs[113]*Hs[114] + 4*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20]*Gsp[36]*Hs[113]*Hs[114] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[24]*Gsp[36]*Hs[113]*Hs[114] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17]*Gsp[40]*Hs[113]*Hs[114] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18]*Gsp[40]*Hs[113]*Hs[114] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18]*Gsp[40]*Hs[113]*Hs[114] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18]*Gsp[40]*Hs[113]*Hs[114] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20]*Gsp[40]*Hs[113]*Hs[114] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24]*Gsp[40]*Hs[113]*Hs[114] - 2*bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24]*Gsp[40]*Hs[113]*Hs[114] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]*Gsp[40]*Hs[113]*Hs[114] + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(rrhoa,2)*pow(zbar,aalpha)*pow(Hs[114],2) + aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[513]*pow(Hs[114],2) + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[514]*pow(Hs[114],2) - aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[514]*pow(Hs[114],2) - abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*G2sp[514]*pow(Hs[114],2) + bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*G2sp[516]*pow(Hs[114],2) + bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[520]*pow(Hs[114],2) - bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[520]*pow(Hs[114],2) + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[520]*pow(Hs[114],2) + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha)*Gsp[33]*pow(Hs[114],2) + pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*pow(Gsp[33],2)*pow(Hs[114],2) + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha)*Gsp[34]*pow(Hs[114],2) - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha)*Gsp[34]*pow(Hs[114],2) - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*rrhoa*pow(zbar,aalpha)*Gsp[34]*pow(Hs[114],2) + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33]*Gsp[34]*pow(Hs[114],2) - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33]*Gsp[34]*pow(Hs[114],2) - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[33]*Gsp[34]*pow(Hs[114],2) + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*pow(Gsp[34],2)*pow(Hs[114],2) - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*pow(Gsp[34],2)*pow(Hs[114],2) + pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*pow(Gsp[34],2)*pow(Hs[114],2) - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*pow(Gsp[34],2)*pow(Hs[114],2) + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*pow(Gsp[34],2)*pow(Hs[114],2) + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,3)*pow(zbar,aalpha)*pow(Gsp[34],2)*pow(Hs[114],2) + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*pow(Gsp[36],2)*pow(Hs[114],2) + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha)*Gsp[40]*pow(Hs[114],2) + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33]*Gsp[40]*pow(Hs[114],2) + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34]*Gsp[40]*pow(Hs[114],2) - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34]*Gsp[40]*pow(Hs[114],2) - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34]*Gsp[40]*pow(Hs[114],2) + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36]*Gsp[40]*pow(Hs[114],2) + bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*pow(Gsp[40],2)*pow(Hs[114],2) - bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*pow(Gsp[40],2)*pow(Hs[114],2) + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*pow(Gsp[40],2)*pow(Hs[114],2) + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[945]*Hs[115] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[946]*Hs[115] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[946]*Hs[115] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*G2sp[946]*Hs[115] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*G2sp[948]*Hs[115] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[952]*Hs[115] - 2*bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[952]*Hs[115] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[952]*Hs[115] - 2*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho)*Gs[232]*Hs[115] + 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha)*Gsp[225]*Hs[115] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha)*Gsp[225]*Hs[115] + 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49]*Gsp[225]*Hs[115] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50]*Gsp[225]*Hs[115] - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50]*Gsp[225]*Hs[115] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50]*Gsp[225]*Hs[115] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]*Gsp[225]*Hs[115] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha)*Gsp[226]*Hs[115] - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha)*Gsp[226]*Hs[115] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*rrhoz*pow(zbar,aalpha)*Gsp[226]*Hs[115] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha)*Gsp[226]*Hs[115] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha)*Gsp[226]*Hs[115] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*rrho*rrhoz*pow(zbar,aalpha)*Gsp[226]*Hs[115] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49]*Gsp[226]*Hs[115] - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49]*Gsp[226]*Hs[115] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[49]*Gsp[226]*Hs[115] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50]*Gsp[226]*Hs[115] - 4*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50]*Gsp[226]*Hs[115] + 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50]*Gsp[226]*Hs[115] - 4*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50]*Gsp[226]*Hs[115] + 4*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50]*Gsp[226]*Hs[115] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,3)*pow(zbar,aalpha)*Gsp[50]*Gsp[226]*Hs[115] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]*Gsp[226]*Hs[115] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]*Gsp[226]*Hs[115] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[56]*Gsp[226]*Hs[115] + 4*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2)*Gsp[228]*Hs[115] - 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrho*rrhoz*pow(zbar,2)*Gsp[228]*Hs[115] + 4*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52]*Gsp[228]*Hs[115] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[56]*Gsp[228]*Hs[115] - 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz*Gsp[232]*Hs[115] + 2*bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz*Gsp[232]*Hs[115] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2)*Gsp[232]*Hs[115] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha)*Gsp[232]*Hs[115] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha)*Gsp[232]*Hs[115] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49]*Gsp[232]*Hs[115] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50]*Gsp[232]*Hs[115] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50]*Gsp[232]*Hs[115] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50]*Gsp[232]*Hs[115] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52]*Gsp[232]*Hs[115] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56]*Gsp[232]*Hs[115] - 2*bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56]*Gsp[232]*Hs[115] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]*Gsp[232]*Hs[115] - 4*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2)*Hs[112]*Hs[115] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrho*rrhoz*pow(zbar,2)*Hs[112]*Hs[115] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha)*Hs[112]*Hs[115] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*rrhoz*pow(zbar,aalpha)*Hs[112]*Hs[115] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha)*Hs[112]*Hs[115] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*rrho*rrhoz*pow(zbar,aalpha)*Hs[112]*Hs[115] - 2*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho)*Hs[112]*Hs[115] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[49]*Hs[112]*Hs[115] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[50]*Hs[112]*Hs[115] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[50]*Hs[112]*Hs[115] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*G2sp[50]*Hs[112]*Hs[115] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*G2sp[52]*Hs[112]*Hs[115] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[56]*Hs[112]*Hs[115] - 2*bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[56]*Hs[112]*Hs[115] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[56]*Hs[112]*Hs[115] + 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha)*Gsp[1]*Hs[112]*Hs[115] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha)*Gsp[1]*Hs[112]*Hs[115] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha)*Gsp[2]*Hs[112]*Hs[115] - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha)*Gsp[2]*Hs[112]*Hs[115] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*rrhoz*pow(zbar,aalpha)*Gsp[2]*Hs[112]*Hs[115] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha)*Gsp[2]*Hs[112]*Hs[115] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha)*Gsp[2]*Hs[112]*Hs[115] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*rrho*rrhoz*pow(zbar,aalpha)*Gsp[2]*Hs[112]*Hs[115] + 4*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2)*Gsp[4]*Hs[112]*Hs[115] - 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrho*rrhoz*pow(zbar,2)*Gsp[4]*Hs[112]*Hs[115] - 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz*Gsp[8]*Hs[112]*Hs[115] + 2*bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz*Gsp[8]*Hs[112]*Hs[115] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2)*Gsp[8]*Hs[112]*Hs[115] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha)*Gsp[8]*Hs[112]*Hs[115] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha)*Gsp[8]*Hs[112]*Hs[115] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49]*Hs[112]*Hs[115] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[49]*Hs[112]*Hs[115] + 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1]*Gsp[49]*Hs[112]*Hs[115] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2]*Gsp[49]*Hs[112]*Hs[115] - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2]*Gsp[49]*Hs[112]*Hs[115] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2]*Gsp[49]*Hs[112]*Hs[115] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]*Gsp[49]*Hs[112]*Hs[115] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50]*Hs[112]*Hs[115] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50]*Hs[112]*Hs[115] + 4*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50]*Hs[112]*Hs[115] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50]*Hs[112]*Hs[115] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,3)*pow(zbar,aalpha)*Gsp[50]*Hs[112]*Hs[115] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1]*Gsp[50]*Hs[112]*Hs[115] - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1]*Gsp[50]*Hs[112]*Hs[115] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[1]*Gsp[50]*Hs[112]*Hs[115] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2]*Gsp[50]*Hs[112]*Hs[115] - 4*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2]*Gsp[50]*Hs[112]*Hs[115] + 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2]*Gsp[50]*Hs[112]*Hs[115] - 4*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2]*Gsp[50]*Hs[112]*Hs[115] + 4*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2]*Gsp[50]*Hs[112]*Hs[115] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,3)*pow(zbar,aalpha)*Gsp[2]*Gsp[50]*Hs[112]*Hs[115] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]*Gsp[50]*Hs[112]*Hs[115] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]*Gsp[50]*Hs[112]*Hs[115] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[8]*Gsp[50]*Hs[112]*Hs[115] - 4*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52]*Hs[112]*Hs[115] + 4*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4]*Gsp[52]*Hs[112]*Hs[115] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[8]*Gsp[52]*Hs[112]*Hs[115] - 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[56]*Hs[112]*Hs[115] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]*Hs[112]*Hs[115] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[56]*Hs[112]*Hs[115] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1]*Gsp[56]*Hs[112]*Hs[115] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2]*Gsp[56]*Hs[112]*Hs[115] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2]*Gsp[56]*Hs[112]*Hs[115] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2]*Gsp[56]*Hs[112]*Hs[115] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4]*Gsp[56]*Hs[112]*Hs[115] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8]*Gsp[56]*Hs[112]*Hs[115] - 2*bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8]*Gsp[56]*Hs[112]*Hs[115] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]*Gsp[56]*Hs[112]*Hs[115] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[289]*Hs[113]*Hs[115] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[290]*Hs[113]*Hs[115] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[290]*Hs[113]*Hs[115] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*G2sp[290]*Hs[113]*Hs[115] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*G2sp[292]*Hs[113]*Hs[115] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[296]*Hs[113]*Hs[115] - 2*bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[296]*Hs[113]*Hs[115] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[296]*Hs[113]*Hs[115] + 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha)*Gsp[17]*Hs[113]*Hs[115] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha)*Gsp[17]*Hs[113]*Hs[115] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha)*Gsp[18]*Hs[113]*Hs[115] - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha)*Gsp[18]*Hs[113]*Hs[115] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*rrhoz*pow(zbar,aalpha)*Gsp[18]*Hs[113]*Hs[115] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha)*Gsp[18]*Hs[113]*Hs[115] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha)*Gsp[18]*Hs[113]*Hs[115] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*rrho*rrhoz*pow(zbar,aalpha)*Gsp[18]*Hs[113]*Hs[115] + 4*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2)*Gsp[20]*Hs[113]*Hs[115] - 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrho*rrhoz*pow(zbar,2)*Gsp[20]*Hs[113]*Hs[115] - 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz*Gsp[24]*Hs[113]*Hs[115] + 2*bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz*Gsp[24]*Hs[113]*Hs[115] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2)*Gsp[24]*Hs[113]*Hs[115] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha)*Gsp[24]*Hs[113]*Hs[115] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha)*Gsp[24]*Hs[113]*Hs[115] + 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17]*Gsp[49]*Hs[113]*Hs[115] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18]*Gsp[49]*Hs[113]*Hs[115] - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18]*Gsp[49]*Hs[113]*Hs[115] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18]*Gsp[49]*Hs[113]*Hs[115] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]*Gsp[49]*Hs[113]*Hs[115] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17]*Gsp[50]*Hs[113]*Hs[115] - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17]*Gsp[50]*Hs[113]*Hs[115] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[17]*Gsp[50]*Hs[113]*Hs[115] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18]*Gsp[50]*Hs[113]*Hs[115] - 4*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18]*Gsp[50]*Hs[113]*Hs[115] + 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18]*Gsp[50]*Hs[113]*Hs[115] - 4*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18]*Gsp[50]*Hs[113]*Hs[115] + 4*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18]*Gsp[50]*Hs[113]*Hs[115] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,3)*pow(zbar,aalpha)*Gsp[18]*Gsp[50]*Hs[113]*Hs[115] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]*Gsp[50]*Hs[113]*Hs[115] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]*Gsp[50]*Hs[113]*Hs[115] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[24]*Gsp[50]*Hs[113]*Hs[115] + 4*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20]*Gsp[52]*Hs[113]*Hs[115] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[24]*Gsp[52]*Hs[113]*Hs[115] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17]*Gsp[56]*Hs[113]*Hs[115] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18]*Gsp[56]*Hs[113]*Hs[115] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18]*Gsp[56]*Hs[113]*Hs[115] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18]*Gsp[56]*Hs[113]*Hs[115] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20]*Gsp[56]*Hs[113]*Hs[115] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24]*Gsp[56]*Hs[113]*Hs[115] - 2*bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24]*Gsp[56]*Hs[113]*Hs[115] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]*Gsp[56]*Hs[113]*Hs[115] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*rrhoz*pow(zbar,aalpha)*Hs[114]*Hs[115] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoa*rrhoz*pow(zbar,aalpha)*Hs[114]*Hs[115] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[529]*Hs[114]*Hs[115] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[530]*Hs[114]*Hs[115] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[530]*Hs[114]*Hs[115] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*G2sp[530]*Hs[114]*Hs[115] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*G2sp[532]*Hs[114]*Hs[115] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[536]*Hs[114]*Hs[115] - 2*bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[536]*Hs[114]*Hs[115] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[536]*Hs[114]*Hs[115] + 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha)*Gsp[33]*Hs[114]*Hs[115] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha)*Gsp[33]*Hs[114]*Hs[115] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha)*Gsp[34]*Hs[114]*Hs[115] - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha)*Gsp[34]*Hs[114]*Hs[115] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*rrhoz*pow(zbar,aalpha)*Gsp[34]*Hs[114]*Hs[115] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha)*Gsp[34]*Hs[114]*Hs[115] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha)*Gsp[34]*Hs[114]*Hs[115] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*rrho*rrhoz*pow(zbar,aalpha)*Gsp[34]*Hs[114]*Hs[115] + 4*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2)*Gsp[36]*Hs[114]*Hs[115] - 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrho*rrhoz*pow(zbar,2)*Gsp[36]*Hs[114]*Hs[115] - 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz*Gsp[40]*Hs[114]*Hs[115] + 2*bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz*Gsp[40]*Hs[114]*Hs[115] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2)*Gsp[40]*Hs[114]*Hs[115] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha)*Gsp[40]*Hs[114]*Hs[115] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha)*Gsp[40]*Hs[114]*Hs[115] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha)*Gsp[49]*Hs[114]*Hs[115] + 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33]*Gsp[49]*Hs[114]*Hs[115] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34]*Gsp[49]*Hs[114]*Hs[115] - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34]*Gsp[49]*Hs[114]*Hs[115] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34]*Gsp[49]*Hs[114]*Hs[115] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]*Gsp[49]*Hs[114]*Hs[115] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha)*Gsp[50]*Hs[114]*Hs[115] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha)*Gsp[50]*Hs[114]*Hs[115] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*rrhoa*pow(zbar,aalpha)*Gsp[50]*Hs[114]*Hs[115] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33]*Gsp[50]*Hs[114]*Hs[115] - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33]*Gsp[50]*Hs[114]*Hs[115] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[33]*Gsp[50]*Hs[114]*Hs[115] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34]*Gsp[50]*Hs[114]*Hs[115] - 4*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34]*Gsp[50]*Hs[114]*Hs[115] + 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34]*Gsp[50]*Hs[114]*Hs[115] - 4*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34]*Gsp[50]*Hs[114]*Hs[115] + 4*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34]*Gsp[50]*Hs[114]*Hs[115] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,3)*pow(zbar,aalpha)*Gsp[34]*Gsp[50]*Hs[114]*Hs[115] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]*Gsp[50]*Hs[114]*Hs[115] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]*Gsp[50]*Hs[114]*Hs[115] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[40]*Gsp[50]*Hs[114]*Hs[115] + 4*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36]*Gsp[52]*Hs[114]*Hs[115] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[40]*Gsp[52]*Hs[114]*Hs[115] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha)*Gsp[56]*Hs[114]*Hs[115] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33]*Gsp[56]*Hs[114]*Hs[115] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34]*Gsp[56]*Hs[114]*Hs[115] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34]*Gsp[56]*Hs[114]*Hs[115] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34]*Gsp[56]*Hs[114]*Hs[115] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36]*Gsp[56]*Hs[114]*Hs[115] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40]*Gsp[56]*Hs[114]*Hs[115] - 2*bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40]*Gsp[56]*Hs[114]*Hs[115] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]*Gsp[56]*Hs[114]*Hs[115] + bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*pow(rrho,2)*pow(rrhoz,2)*pow(Hs[115],2) - bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*pow(rrho,2)*pow(rrhoz,2)*pow(Hs[115],2) + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(rrhoz,2)*pow(zbar,2)*pow(Hs[115],2) - 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrho*pow(rrhoz,2)*pow(zbar,2)*pow(Hs[115],2) + pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(rrhoz,2)*pow(zbar,aalpha)*pow(Hs[115],2) - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*pow(rrhoz,2)*pow(zbar,aalpha)*pow(Hs[115],2) + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(rrho,2)*pow(rrhoz,2)*pow(zbar,aalpha)*pow(Hs[115],2) - pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho)*pow(Hs[115],2) + aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[769]*pow(Hs[115],2) + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[770]*pow(Hs[115],2) - aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[770]*pow(Hs[115],2) - abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*G2sp[770]*pow(Hs[115],2) + bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*G2sp[772]*pow(Hs[115],2) + bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[776]*pow(Hs[115],2) - bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[776]*pow(Hs[115],2) + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[776]*pow(Hs[115],2) + 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha)*Gsp[49]*pow(Hs[115],2) - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha)*Gsp[49]*pow(Hs[115],2) + pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*pow(Gsp[49],2)*pow(Hs[115],2) + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha)*Gsp[50]*pow(Hs[115],2) - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha)*Gsp[50]*pow(Hs[115],2) - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*rrhoz*pow(zbar,aalpha)*Gsp[50]*pow(Hs[115],2) - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha)*Gsp[50]*pow(Hs[115],2) + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha)*Gsp[50]*pow(Hs[115],2) + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*rrho*rrhoz*pow(zbar,aalpha)*Gsp[50]*pow(Hs[115],2) + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49]*Gsp[50]*pow(Hs[115],2) - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49]*Gsp[50]*pow(Hs[115],2) - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[49]*Gsp[50]*pow(Hs[115],2) + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*pow(Gsp[50],2)*pow(Hs[115],2) - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*pow(Gsp[50],2)*pow(Hs[115],2) + pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*pow(Gsp[50],2)*pow(Hs[115],2) - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*pow(Gsp[50],2)*pow(Hs[115],2) + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*pow(Gsp[50],2)*pow(Hs[115],2) + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,3)*pow(zbar,aalpha)*pow(Gsp[50],2)*pow(Hs[115],2) + 4*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2)*Gsp[52]*pow(Hs[115],2) - 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrho*rrhoz*pow(zbar,2)*Gsp[52]*pow(Hs[115],2) + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*pow(Gsp[52],2)*pow(Hs[115],2) - 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz*Gsp[56]*pow(Hs[115],2) + 2*bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz*Gsp[56]*pow(Hs[115],2) + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2)*Gsp[56]*pow(Hs[115],2) + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha)*Gsp[56]*pow(Hs[115],2) - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha)*Gsp[56]*pow(Hs[115],2) + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49]*Gsp[56]*pow(Hs[115],2) + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50]*Gsp[56]*pow(Hs[115],2) - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50]*Gsp[56]*pow(Hs[115],2) - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50]*Gsp[56]*pow(Hs[115],2) + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52]*Gsp[56]*pow(Hs[115],2) + bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*pow(Gsp[56],2)*pow(Hs[115],2) - bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*pow(Gsp[56],2)*pow(Hs[115],2) + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*pow(Gsp[56],2)*pow(Hs[115],2) + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[1185]*Hs[116] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[1186]*Hs[116] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[1186]*Hs[116] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*G2sp[1186]*Hs[116] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*G2sp[1188]*Hs[116] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[1192]*Hs[116] - 2*bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[1192]*Hs[116] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[1192]*Hs[116] + 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65]*Gsp[225]*Hs[116] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66]*Gsp[225]*Hs[116] - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66]*Gsp[225]*Hs[116] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66]*Gsp[225]*Hs[116] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]*Gsp[225]*Hs[116] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65]*Gsp[226]*Hs[116] - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65]*Gsp[226]*Hs[116] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[65]*Gsp[226]*Hs[116] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66]*Gsp[226]*Hs[116] - 4*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66]*Gsp[226]*Hs[116] + 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66]*Gsp[226]*Hs[116] - 4*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66]*Gsp[226]*Hs[116] + 4*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66]*Gsp[226]*Hs[116] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,3)*pow(zbar,aalpha)*Gsp[66]*Gsp[226]*Hs[116] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]*Gsp[226]*Hs[116] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]*Gsp[226]*Hs[116] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[72]*Gsp[226]*Hs[116] + 4*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68]*Gsp[228]*Hs[116] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[72]*Gsp[228]*Hs[116] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65]*Gsp[232]*Hs[116] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66]*Gsp[232]*Hs[116] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66]*Gsp[232]*Hs[116] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66]*Gsp[232]*Hs[116] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68]*Gsp[232]*Hs[116] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72]*Gsp[232]*Hs[116] - 2*bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72]*Gsp[232]*Hs[116] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]*Gsp[232]*Hs[116] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[65]*Hs[112]*Hs[116] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[66]*Hs[112]*Hs[116] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[66]*Hs[112]*Hs[116] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*G2sp[66]*Hs[112]*Hs[116] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*G2sp[68]*Hs[112]*Hs[116] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[72]*Hs[112]*Hs[116] - 2*bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[72]*Hs[112]*Hs[116] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[72]*Hs[112]*Hs[116] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65]*Hs[112]*Hs[116] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[65]*Hs[112]*Hs[116] + 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1]*Gsp[65]*Hs[112]*Hs[116] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2]*Gsp[65]*Hs[112]*Hs[116] - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2]*Gsp[65]*Hs[112]*Hs[116] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2]*Gsp[65]*Hs[112]*Hs[116] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]*Gsp[65]*Hs[112]*Hs[116] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66]*Hs[112]*Hs[116] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66]*Hs[112]*Hs[116] + 4*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66]*Hs[112]*Hs[116] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66]*Hs[112]*Hs[116] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,3)*pow(zbar,aalpha)*Gsp[66]*Hs[112]*Hs[116] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1]*Gsp[66]*Hs[112]*Hs[116] - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1]*Gsp[66]*Hs[112]*Hs[116] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[1]*Gsp[66]*Hs[112]*Hs[116] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2]*Gsp[66]*Hs[112]*Hs[116] - 4*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2]*Gsp[66]*Hs[112]*Hs[116] + 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2]*Gsp[66]*Hs[112]*Hs[116] - 4*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2]*Gsp[66]*Hs[112]*Hs[116] + 4*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2]*Gsp[66]*Hs[112]*Hs[116] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,3)*pow(zbar,aalpha)*Gsp[2]*Gsp[66]*Hs[112]*Hs[116] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]*Gsp[66]*Hs[112]*Hs[116] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]*Gsp[66]*Hs[112]*Hs[116] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[8]*Gsp[66]*Hs[112]*Hs[116] - 4*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68]*Hs[112]*Hs[116] + 4*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4]*Gsp[68]*Hs[112]*Hs[116] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[8]*Gsp[68]*Hs[112]*Hs[116] - 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[72]*Hs[112]*Hs[116] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]*Hs[112]*Hs[116] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[72]*Hs[112]*Hs[116] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1]*Gsp[72]*Hs[112]*Hs[116] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2]*Gsp[72]*Hs[112]*Hs[116] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2]*Gsp[72]*Hs[112]*Hs[116] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2]*Gsp[72]*Hs[112]*Hs[116] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4]*Gsp[72]*Hs[112]*Hs[116] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8]*Gsp[72]*Hs[112]*Hs[116] - 2*bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8]*Gsp[72]*Hs[112]*Hs[116] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]*Gsp[72]*Hs[112]*Hs[116] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[305]*Hs[113]*Hs[116] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[306]*Hs[113]*Hs[116] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[306]*Hs[113]*Hs[116] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*G2sp[306]*Hs[113]*Hs[116] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*G2sp[308]*Hs[113]*Hs[116] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[312]*Hs[113]*Hs[116] - 2*bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[312]*Hs[113]*Hs[116] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[312]*Hs[113]*Hs[116] + 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17]*Gsp[65]*Hs[113]*Hs[116] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18]*Gsp[65]*Hs[113]*Hs[116] - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18]*Gsp[65]*Hs[113]*Hs[116] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18]*Gsp[65]*Hs[113]*Hs[116] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]*Gsp[65]*Hs[113]*Hs[116] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17]*Gsp[66]*Hs[113]*Hs[116] - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17]*Gsp[66]*Hs[113]*Hs[116] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[17]*Gsp[66]*Hs[113]*Hs[116] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18]*Gsp[66]*Hs[113]*Hs[116] - 4*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18]*Gsp[66]*Hs[113]*Hs[116] + 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18]*Gsp[66]*Hs[113]*Hs[116] - 4*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18]*Gsp[66]*Hs[113]*Hs[116] + 4*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18]*Gsp[66]*Hs[113]*Hs[116] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,3)*pow(zbar,aalpha)*Gsp[18]*Gsp[66]*Hs[113]*Hs[116] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]*Gsp[66]*Hs[113]*Hs[116] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]*Gsp[66]*Hs[113]*Hs[116] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[24]*Gsp[66]*Hs[113]*Hs[116] + 4*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20]*Gsp[68]*Hs[113]*Hs[116] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[24]*Gsp[68]*Hs[113]*Hs[116] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17]*Gsp[72]*Hs[113]*Hs[116] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18]*Gsp[72]*Hs[113]*Hs[116] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18]*Gsp[72]*Hs[113]*Hs[116] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18]*Gsp[72]*Hs[113]*Hs[116] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20]*Gsp[72]*Hs[113]*Hs[116] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24]*Gsp[72]*Hs[113]*Hs[116] - 2*bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24]*Gsp[72]*Hs[113]*Hs[116] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]*Gsp[72]*Hs[113]*Hs[116] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[545]*Hs[114]*Hs[116] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[546]*Hs[114]*Hs[116] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[546]*Hs[114]*Hs[116] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*G2sp[546]*Hs[114]*Hs[116] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*G2sp[548]*Hs[114]*Hs[116] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[552]*Hs[114]*Hs[116] - 2*bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[552]*Hs[114]*Hs[116] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[552]*Hs[114]*Hs[116] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha)*Gsp[65]*Hs[114]*Hs[116] + 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33]*Gsp[65]*Hs[114]*Hs[116] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34]*Gsp[65]*Hs[114]*Hs[116] - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34]*Gsp[65]*Hs[114]*Hs[116] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34]*Gsp[65]*Hs[114]*Hs[116] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]*Gsp[65]*Hs[114]*Hs[116] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha)*Gsp[66]*Hs[114]*Hs[116] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha)*Gsp[66]*Hs[114]*Hs[116] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*rrhoa*pow(zbar,aalpha)*Gsp[66]*Hs[114]*Hs[116] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33]*Gsp[66]*Hs[114]*Hs[116] - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33]*Gsp[66]*Hs[114]*Hs[116] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[33]*Gsp[66]*Hs[114]*Hs[116] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34]*Gsp[66]*Hs[114]*Hs[116] - 4*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34]*Gsp[66]*Hs[114]*Hs[116] + 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34]*Gsp[66]*Hs[114]*Hs[116] - 4*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34]*Gsp[66]*Hs[114]*Hs[116] + 4*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34]*Gsp[66]*Hs[114]*Hs[116] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,3)*pow(zbar,aalpha)*Gsp[34]*Gsp[66]*Hs[114]*Hs[116] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]*Gsp[66]*Hs[114]*Hs[116] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]*Gsp[66]*Hs[114]*Hs[116] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[40]*Gsp[66]*Hs[114]*Hs[116] + 4*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36]*Gsp[68]*Hs[114]*Hs[116] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[40]*Gsp[68]*Hs[114]*Hs[116] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha)*Gsp[72]*Hs[114]*Hs[116] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33]*Gsp[72]*Hs[114]*Hs[116] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34]*Gsp[72]*Hs[114]*Hs[116] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34]*Gsp[72]*Hs[114]*Hs[116] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34]*Gsp[72]*Hs[114]*Hs[116] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36]*Gsp[72]*Hs[114]*Hs[116] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40]*Gsp[72]*Hs[114]*Hs[116] - 2*bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40]*Gsp[72]*Hs[114]*Hs[116] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]*Gsp[72]*Hs[114]*Hs[116] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[785]*Hs[115]*Hs[116] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[786]*Hs[115]*Hs[116] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[786]*Hs[115]*Hs[116] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*G2sp[786]*Hs[115]*Hs[116] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*G2sp[788]*Hs[115]*Hs[116] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[792]*Hs[115]*Hs[116] - 2*bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[792]*Hs[115]*Hs[116] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[792]*Hs[115]*Hs[116] + 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha)*Gsp[65]*Hs[115]*Hs[116] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha)*Gsp[65]*Hs[115]*Hs[116] + 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49]*Gsp[65]*Hs[115]*Hs[116] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50]*Gsp[65]*Hs[115]*Hs[116] - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50]*Gsp[65]*Hs[115]*Hs[116] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50]*Gsp[65]*Hs[115]*Hs[116] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]*Gsp[65]*Hs[115]*Hs[116] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha)*Gsp[66]*Hs[115]*Hs[116] - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha)*Gsp[66]*Hs[115]*Hs[116] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*rrhoz*pow(zbar,aalpha)*Gsp[66]*Hs[115]*Hs[116] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha)*Gsp[66]*Hs[115]*Hs[116] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha)*Gsp[66]*Hs[115]*Hs[116] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*rrho*rrhoz*pow(zbar,aalpha)*Gsp[66]*Hs[115]*Hs[116] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49]*Gsp[66]*Hs[115]*Hs[116] - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49]*Gsp[66]*Hs[115]*Hs[116] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[49]*Gsp[66]*Hs[115]*Hs[116] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50]*Gsp[66]*Hs[115]*Hs[116] - 4*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50]*Gsp[66]*Hs[115]*Hs[116] + 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50]*Gsp[66]*Hs[115]*Hs[116] - 4*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50]*Gsp[66]*Hs[115]*Hs[116] + 4*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50]*Gsp[66]*Hs[115]*Hs[116] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,3)*pow(zbar,aalpha)*Gsp[50]*Gsp[66]*Hs[115]*Hs[116] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]*Gsp[66]*Hs[115]*Hs[116] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]*Gsp[66]*Hs[115]*Hs[116] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[56]*Gsp[66]*Hs[115]*Hs[116] + 4*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2)*Gsp[68]*Hs[115]*Hs[116] - 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrho*rrhoz*pow(zbar,2)*Gsp[68]*Hs[115]*Hs[116] + 4*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52]*Gsp[68]*Hs[115]*Hs[116] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[56]*Gsp[68]*Hs[115]*Hs[116] - 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz*Gsp[72]*Hs[115]*Hs[116] + 2*bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz*Gsp[72]*Hs[115]*Hs[116] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2)*Gsp[72]*Hs[115]*Hs[116] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha)*Gsp[72]*Hs[115]*Hs[116] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha)*Gsp[72]*Hs[115]*Hs[116] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49]*Gsp[72]*Hs[115]*Hs[116] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50]*Gsp[72]*Hs[115]*Hs[116] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50]*Gsp[72]*Hs[115]*Hs[116] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50]*Gsp[72]*Hs[115]*Hs[116] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52]*Gsp[72]*Hs[115]*Hs[116] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56]*Gsp[72]*Hs[115]*Hs[116] - 2*bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56]*Gsp[72]*Hs[115]*Hs[116] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]*Gsp[72]*Hs[115]*Hs[116] + aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[1025]*pow(Hs[116],2) + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[1026]*pow(Hs[116],2) - aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[1026]*pow(Hs[116],2) - abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*G2sp[1026]*pow(Hs[116],2) + bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*G2sp[1028]*pow(Hs[116],2) + bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[1032]*pow(Hs[116],2) - bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[1032]*pow(Hs[116],2) + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[1032]*pow(Hs[116],2) + pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*pow(Gsp[65],2)*pow(Hs[116],2) + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65]*Gsp[66]*pow(Hs[116],2) - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65]*Gsp[66]*pow(Hs[116],2) - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[65]*Gsp[66]*pow(Hs[116],2) + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*pow(Gsp[66],2)*pow(Hs[116],2) - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*pow(Gsp[66],2)*pow(Hs[116],2) + pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*pow(Gsp[66],2)*pow(Hs[116],2) - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*pow(Gsp[66],2)*pow(Hs[116],2) + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*pow(Gsp[66],2)*pow(Hs[116],2) + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,3)*pow(zbar,aalpha)*pow(Gsp[66],2)*pow(Hs[116],2) + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*pow(Gsp[68],2)*pow(Hs[116],2) + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65]*Gsp[72]*pow(Hs[116],2) + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66]*Gsp[72]*pow(Hs[116],2) - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66]*Gsp[72]*pow(Hs[116],2) - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66]*Gsp[72]*pow(Hs[116],2) + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68]*Gsp[72]*pow(Hs[116],2) + bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*pow(Gsp[72],2)*pow(Hs[116],2) - bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*pow(Gsp[72],2)*pow(Hs[116],2) + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*pow(Gsp[72],2)*pow(Hs[116],2) + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[1425]*Hs[117] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[1426]*Hs[117] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[1426]*Hs[117] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*G2sp[1426]*Hs[117] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*G2sp[1428]*Hs[117] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[1432]*Hs[117] - 2*bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[1432]*Hs[117] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[1432]*Hs[117] + 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81]*Gsp[225]*Hs[117] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82]*Gsp[225]*Hs[117] - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82]*Gsp[225]*Hs[117] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82]*Gsp[225]*Hs[117] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]*Gsp[225]*Hs[117] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81]*Gsp[226]*Hs[117] - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81]*Gsp[226]*Hs[117] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[81]*Gsp[226]*Hs[117] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82]*Gsp[226]*Hs[117] - 4*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82]*Gsp[226]*Hs[117] + 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82]*Gsp[226]*Hs[117] - 4*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82]*Gsp[226]*Hs[117] + 4*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82]*Gsp[226]*Hs[117] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,3)*pow(zbar,aalpha)*Gsp[82]*Gsp[226]*Hs[117] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]*Gsp[226]*Hs[117] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]*Gsp[226]*Hs[117] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[88]*Gsp[226]*Hs[117] + 4*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84]*Gsp[228]*Hs[117] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[88]*Gsp[228]*Hs[117] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81]*Gsp[232]*Hs[117] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82]*Gsp[232]*Hs[117] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82]*Gsp[232]*Hs[117] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82]*Gsp[232]*Hs[117] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84]*Gsp[232]*Hs[117] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88]*Gsp[232]*Hs[117] - 2*bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88]*Gsp[232]*Hs[117] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]*Gsp[232]*Hs[117] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[81]*Hs[112]*Hs[117] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[82]*Hs[112]*Hs[117] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[82]*Hs[112]*Hs[117] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*G2sp[82]*Hs[112]*Hs[117] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*G2sp[84]*Hs[112]*Hs[117] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[88]*Hs[112]*Hs[117] - 2*bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[88]*Hs[112]*Hs[117] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[88]*Hs[112]*Hs[117] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81]*Hs[112]*Hs[117] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[81]*Hs[112]*Hs[117] + 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1]*Gsp[81]*Hs[112]*Hs[117] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2]*Gsp[81]*Hs[112]*Hs[117] - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2]*Gsp[81]*Hs[112]*Hs[117] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2]*Gsp[81]*Hs[112]*Hs[117] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]*Gsp[81]*Hs[112]*Hs[117] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82]*Hs[112]*Hs[117] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82]*Hs[112]*Hs[117] + 4*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82]*Hs[112]*Hs[117] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82]*Hs[112]*Hs[117] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,3)*pow(zbar,aalpha)*Gsp[82]*Hs[112]*Hs[117] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1]*Gsp[82]*Hs[112]*Hs[117] - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1]*Gsp[82]*Hs[112]*Hs[117] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[1]*Gsp[82]*Hs[112]*Hs[117] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2]*Gsp[82]*Hs[112]*Hs[117] - 4*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2]*Gsp[82]*Hs[112]*Hs[117] + 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2]*Gsp[82]*Hs[112]*Hs[117] - 4*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2]*Gsp[82]*Hs[112]*Hs[117] + 4*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2]*Gsp[82]*Hs[112]*Hs[117] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,3)*pow(zbar,aalpha)*Gsp[2]*Gsp[82]*Hs[112]*Hs[117] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]*Gsp[82]*Hs[112]*Hs[117] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]*Gsp[82]*Hs[112]*Hs[117] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[8]*Gsp[82]*Hs[112]*Hs[117] - 4*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84]*Hs[112]*Hs[117] + 4*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4]*Gsp[84]*Hs[112]*Hs[117] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[8]*Gsp[84]*Hs[112]*Hs[117] - 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[88]*Hs[112]*Hs[117] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]*Hs[112]*Hs[117] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[88]*Hs[112]*Hs[117] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1]*Gsp[88]*Hs[112]*Hs[117] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2]*Gsp[88]*Hs[112]*Hs[117] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2]*Gsp[88]*Hs[112]*Hs[117] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2]*Gsp[88]*Hs[112]*Hs[117] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4]*Gsp[88]*Hs[112]*Hs[117] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8]*Gsp[88]*Hs[112]*Hs[117] - 2*bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8]*Gsp[88]*Hs[112]*Hs[117] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]*Gsp[88]*Hs[112]*Hs[117] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[321]*Hs[113]*Hs[117] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[322]*Hs[113]*Hs[117] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[322]*Hs[113]*Hs[117] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*G2sp[322]*Hs[113]*Hs[117] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*G2sp[324]*Hs[113]*Hs[117] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[328]*Hs[113]*Hs[117] - 2*bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[328]*Hs[113]*Hs[117] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[328]*Hs[113]*Hs[117] + 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17]*Gsp[81]*Hs[113]*Hs[117] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18]*Gsp[81]*Hs[113]*Hs[117] - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18]*Gsp[81]*Hs[113]*Hs[117] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18]*Gsp[81]*Hs[113]*Hs[117] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]*Gsp[81]*Hs[113]*Hs[117] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17]*Gsp[82]*Hs[113]*Hs[117] - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17]*Gsp[82]*Hs[113]*Hs[117] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[17]*Gsp[82]*Hs[113]*Hs[117] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18]*Gsp[82]*Hs[113]*Hs[117] - 4*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18]*Gsp[82]*Hs[113]*Hs[117] + 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18]*Gsp[82]*Hs[113]*Hs[117] - 4*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18]*Gsp[82]*Hs[113]*Hs[117] + 4*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18]*Gsp[82]*Hs[113]*Hs[117] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,3)*pow(zbar,aalpha)*Gsp[18]*Gsp[82]*Hs[113]*Hs[117] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]*Gsp[82]*Hs[113]*Hs[117] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]*Gsp[82]*Hs[113]*Hs[117] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[24]*Gsp[82]*Hs[113]*Hs[117] + 4*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20]*Gsp[84]*Hs[113]*Hs[117] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[24]*Gsp[84]*Hs[113]*Hs[117] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17]*Gsp[88]*Hs[113]*Hs[117] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18]*Gsp[88]*Hs[113]*Hs[117] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18]*Gsp[88]*Hs[113]*Hs[117] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18]*Gsp[88]*Hs[113]*Hs[117] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20]*Gsp[88]*Hs[113]*Hs[117] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24]*Gsp[88]*Hs[113]*Hs[117] - 2*bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24]*Gsp[88]*Hs[113]*Hs[117] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]*Gsp[88]*Hs[113]*Hs[117] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[561]*Hs[114]*Hs[117] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[562]*Hs[114]*Hs[117] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[562]*Hs[114]*Hs[117] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*G2sp[562]*Hs[114]*Hs[117] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*G2sp[564]*Hs[114]*Hs[117] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[568]*Hs[114]*Hs[117] - 2*bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[568]*Hs[114]*Hs[117] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[568]*Hs[114]*Hs[117] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha)*Gsp[81]*Hs[114]*Hs[117] + 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33]*Gsp[81]*Hs[114]*Hs[117] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34]*Gsp[81]*Hs[114]*Hs[117] - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34]*Gsp[81]*Hs[114]*Hs[117] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34]*Gsp[81]*Hs[114]*Hs[117] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]*Gsp[81]*Hs[114]*Hs[117] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha)*Gsp[82]*Hs[114]*Hs[117] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha)*Gsp[82]*Hs[114]*Hs[117] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*rrhoa*pow(zbar,aalpha)*Gsp[82]*Hs[114]*Hs[117] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33]*Gsp[82]*Hs[114]*Hs[117] - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33]*Gsp[82]*Hs[114]*Hs[117] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[33]*Gsp[82]*Hs[114]*Hs[117] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34]*Gsp[82]*Hs[114]*Hs[117] - 4*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34]*Gsp[82]*Hs[114]*Hs[117] + 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34]*Gsp[82]*Hs[114]*Hs[117] - 4*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34]*Gsp[82]*Hs[114]*Hs[117] + 4*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34]*Gsp[82]*Hs[114]*Hs[117] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,3)*pow(zbar,aalpha)*Gsp[34]*Gsp[82]*Hs[114]*Hs[117] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]*Gsp[82]*Hs[114]*Hs[117] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]*Gsp[82]*Hs[114]*Hs[117] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[40]*Gsp[82]*Hs[114]*Hs[117] + 4*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36]*Gsp[84]*Hs[114]*Hs[117] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[40]*Gsp[84]*Hs[114]*Hs[117] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha)*Gsp[88]*Hs[114]*Hs[117] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33]*Gsp[88]*Hs[114]*Hs[117] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34]*Gsp[88]*Hs[114]*Hs[117] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34]*Gsp[88]*Hs[114]*Hs[117] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34]*Gsp[88]*Hs[114]*Hs[117] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36]*Gsp[88]*Hs[114]*Hs[117] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40]*Gsp[88]*Hs[114]*Hs[117] - 2*bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40]*Gsp[88]*Hs[114]*Hs[117] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]*Gsp[88]*Hs[114]*Hs[117] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[801]*Hs[115]*Hs[117] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[802]*Hs[115]*Hs[117] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[802]*Hs[115]*Hs[117] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*G2sp[802]*Hs[115]*Hs[117] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*G2sp[804]*Hs[115]*Hs[117] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[808]*Hs[115]*Hs[117] - 2*bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[808]*Hs[115]*Hs[117] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[808]*Hs[115]*Hs[117] + 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha)*Gsp[81]*Hs[115]*Hs[117] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha)*Gsp[81]*Hs[115]*Hs[117] + 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49]*Gsp[81]*Hs[115]*Hs[117] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50]*Gsp[81]*Hs[115]*Hs[117] - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50]*Gsp[81]*Hs[115]*Hs[117] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50]*Gsp[81]*Hs[115]*Hs[117] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]*Gsp[81]*Hs[115]*Hs[117] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha)*Gsp[82]*Hs[115]*Hs[117] - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha)*Gsp[82]*Hs[115]*Hs[117] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*rrhoz*pow(zbar,aalpha)*Gsp[82]*Hs[115]*Hs[117] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha)*Gsp[82]*Hs[115]*Hs[117] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha)*Gsp[82]*Hs[115]*Hs[117] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*rrho*rrhoz*pow(zbar,aalpha)*Gsp[82]*Hs[115]*Hs[117] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49]*Gsp[82]*Hs[115]*Hs[117] - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49]*Gsp[82]*Hs[115]*Hs[117] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[49]*Gsp[82]*Hs[115]*Hs[117] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50]*Gsp[82]*Hs[115]*Hs[117] - 4*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50]*Gsp[82]*Hs[115]*Hs[117] + 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50]*Gsp[82]*Hs[115]*Hs[117] - 4*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50]*Gsp[82]*Hs[115]*Hs[117] + 4*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50]*Gsp[82]*Hs[115]*Hs[117] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,3)*pow(zbar,aalpha)*Gsp[50]*Gsp[82]*Hs[115]*Hs[117] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]*Gsp[82]*Hs[115]*Hs[117] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]*Gsp[82]*Hs[115]*Hs[117] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[56]*Gsp[82]*Hs[115]*Hs[117] + 4*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2)*Gsp[84]*Hs[115]*Hs[117] - 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrho*rrhoz*pow(zbar,2)*Gsp[84]*Hs[115]*Hs[117] + 4*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52]*Gsp[84]*Hs[115]*Hs[117] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[56]*Gsp[84]*Hs[115]*Hs[117] - 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz*Gsp[88]*Hs[115]*Hs[117] + 2*bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz*Gsp[88]*Hs[115]*Hs[117] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2)*Gsp[88]*Hs[115]*Hs[117] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha)*Gsp[88]*Hs[115]*Hs[117] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha)*Gsp[88]*Hs[115]*Hs[117] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49]*Gsp[88]*Hs[115]*Hs[117] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50]*Gsp[88]*Hs[115]*Hs[117] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50]*Gsp[88]*Hs[115]*Hs[117] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50]*Gsp[88]*Hs[115]*Hs[117] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52]*Gsp[88]*Hs[115]*Hs[117] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56]*Gsp[88]*Hs[115]*Hs[117] - 2*bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56]*Gsp[88]*Hs[115]*Hs[117] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]*Gsp[88]*Hs[115]*Hs[117] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[1041]*Hs[116]*Hs[117] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[1042]*Hs[116]*Hs[117] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[1042]*Hs[116]*Hs[117] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*G2sp[1042]*Hs[116]*Hs[117] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*G2sp[1044]*Hs[116]*Hs[117] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[1048]*Hs[116]*Hs[117] - 2*bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[1048]*Hs[116]*Hs[117] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[1048]*Hs[116]*Hs[117] + 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65]*Gsp[81]*Hs[116]*Hs[117] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66]*Gsp[81]*Hs[116]*Hs[117] - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66]*Gsp[81]*Hs[116]*Hs[117] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66]*Gsp[81]*Hs[116]*Hs[117] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]*Gsp[81]*Hs[116]*Hs[117] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65]*Gsp[82]*Hs[116]*Hs[117] - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65]*Gsp[82]*Hs[116]*Hs[117] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[65]*Gsp[82]*Hs[116]*Hs[117] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66]*Gsp[82]*Hs[116]*Hs[117] - 4*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66]*Gsp[82]*Hs[116]*Hs[117] + 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66]*Gsp[82]*Hs[116]*Hs[117] - 4*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66]*Gsp[82]*Hs[116]*Hs[117] + 4*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66]*Gsp[82]*Hs[116]*Hs[117] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,3)*pow(zbar,aalpha)*Gsp[66]*Gsp[82]*Hs[116]*Hs[117] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]*Gsp[82]*Hs[116]*Hs[117] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]*Gsp[82]*Hs[116]*Hs[117] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[72]*Gsp[82]*Hs[116]*Hs[117] + 4*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68]*Gsp[84]*Hs[116]*Hs[117] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[72]*Gsp[84]*Hs[116]*Hs[117] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65]*Gsp[88]*Hs[116]*Hs[117] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66]*Gsp[88]*Hs[116]*Hs[117] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66]*Gsp[88]*Hs[116]*Hs[117] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66]*Gsp[88]*Hs[116]*Hs[117] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68]*Gsp[88]*Hs[116]*Hs[117] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72]*Gsp[88]*Hs[116]*Hs[117] - 2*bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72]*Gsp[88]*Hs[116]*Hs[117] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]*Gsp[88]*Hs[116]*Hs[117] + aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[1281]*pow(Hs[117],2) + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[1282]*pow(Hs[117],2) - aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[1282]*pow(Hs[117],2) - abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*G2sp[1282]*pow(Hs[117],2) + bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*G2sp[1284]*pow(Hs[117],2) + bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[1288]*pow(Hs[117],2) - bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[1288]*pow(Hs[117],2) + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[1288]*pow(Hs[117],2) + pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*pow(Gsp[81],2)*pow(Hs[117],2) + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81]*Gsp[82]*pow(Hs[117],2) - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81]*Gsp[82]*pow(Hs[117],2) - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[81]*Gsp[82]*pow(Hs[117],2) + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*pow(Gsp[82],2)*pow(Hs[117],2) - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*pow(Gsp[82],2)*pow(Hs[117],2) + pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*pow(Gsp[82],2)*pow(Hs[117],2) - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*pow(Gsp[82],2)*pow(Hs[117],2) + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*pow(Gsp[82],2)*pow(Hs[117],2) + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,3)*pow(zbar,aalpha)*pow(Gsp[82],2)*pow(Hs[117],2) + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*pow(Gsp[84],2)*pow(Hs[117],2) + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81]*Gsp[88]*pow(Hs[117],2) + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82]*Gsp[88]*pow(Hs[117],2) - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82]*Gsp[88]*pow(Hs[117],2) - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82]*Gsp[88]*pow(Hs[117],2) + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84]*Gsp[88]*pow(Hs[117],2) + bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*pow(Gsp[88],2)*pow(Hs[117],2) - bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*pow(Gsp[88],2)*pow(Hs[117],2) + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*pow(Gsp[88],2)*pow(Hs[117],2) + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[1665]*Hs[118] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[1666]*Hs[118] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[1666]*Hs[118] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*G2sp[1666]*Hs[118] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*G2sp[1668]*Hs[118] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[1672]*Hs[118] - 2*bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[1672]*Hs[118] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[1672]*Hs[118] + 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97]*Gsp[225]*Hs[118] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98]*Gsp[225]*Hs[118] - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98]*Gsp[225]*Hs[118] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98]*Gsp[225]*Hs[118] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]*Gsp[225]*Hs[118] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97]*Gsp[226]*Hs[118] - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97]*Gsp[226]*Hs[118] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[97]*Gsp[226]*Hs[118] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98]*Gsp[226]*Hs[118] - 4*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98]*Gsp[226]*Hs[118] + 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98]*Gsp[226]*Hs[118] - 4*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98]*Gsp[226]*Hs[118] + 4*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98]*Gsp[226]*Hs[118] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,3)*pow(zbar,aalpha)*Gsp[98]*Gsp[226]*Hs[118] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]*Gsp[226]*Hs[118] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]*Gsp[226]*Hs[118] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[104]*Gsp[226]*Hs[118] + 4*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100]*Gsp[228]*Hs[118] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[104]*Gsp[228]*Hs[118] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97]*Gsp[232]*Hs[118] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98]*Gsp[232]*Hs[118] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98]*Gsp[232]*Hs[118] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98]*Gsp[232]*Hs[118] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100]*Gsp[232]*Hs[118] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104]*Gsp[232]*Hs[118] - 2*bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104]*Gsp[232]*Hs[118] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]*Gsp[232]*Hs[118] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[97]*Hs[112]*Hs[118] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[98]*Hs[112]*Hs[118] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[98]*Hs[112]*Hs[118] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*G2sp[98]*Hs[112]*Hs[118] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*G2sp[100]*Hs[112]*Hs[118] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[104]*Hs[112]*Hs[118] - 2*bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[104]*Hs[112]*Hs[118] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[104]*Hs[112]*Hs[118] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97]*Hs[112]*Hs[118] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[97]*Hs[112]*Hs[118] + 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1]*Gsp[97]*Hs[112]*Hs[118] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2]*Gsp[97]*Hs[112]*Hs[118] - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2]*Gsp[97]*Hs[112]*Hs[118] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2]*Gsp[97]*Hs[112]*Hs[118] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]*Gsp[97]*Hs[112]*Hs[118] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98]*Hs[112]*Hs[118] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98]*Hs[112]*Hs[118] + 4*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98]*Hs[112]*Hs[118] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98]*Hs[112]*Hs[118] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,3)*pow(zbar,aalpha)*Gsp[98]*Hs[112]*Hs[118] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1]*Gsp[98]*Hs[112]*Hs[118] - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1]*Gsp[98]*Hs[112]*Hs[118] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[1]*Gsp[98]*Hs[112]*Hs[118] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2]*Gsp[98]*Hs[112]*Hs[118] - 4*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2]*Gsp[98]*Hs[112]*Hs[118] + 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2]*Gsp[98]*Hs[112]*Hs[118] - 4*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2]*Gsp[98]*Hs[112]*Hs[118] + 4*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2]*Gsp[98]*Hs[112]*Hs[118] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,3)*pow(zbar,aalpha)*Gsp[2]*Gsp[98]*Hs[112]*Hs[118] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]*Gsp[98]*Hs[112]*Hs[118] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]*Gsp[98]*Hs[112]*Hs[118] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[8]*Gsp[98]*Hs[112]*Hs[118] - 4*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100]*Hs[112]*Hs[118] + 4*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4]*Gsp[100]*Hs[112]*Hs[118] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[8]*Gsp[100]*Hs[112]*Hs[118] - 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[104]*Hs[112]*Hs[118] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]*Hs[112]*Hs[118] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[104]*Hs[112]*Hs[118] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1]*Gsp[104]*Hs[112]*Hs[118] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2]*Gsp[104]*Hs[112]*Hs[118] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2]*Gsp[104]*Hs[112]*Hs[118] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2]*Gsp[104]*Hs[112]*Hs[118] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4]*Gsp[104]*Hs[112]*Hs[118] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8]*Gsp[104]*Hs[112]*Hs[118] - 2*bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8]*Gsp[104]*Hs[112]*Hs[118] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]*Gsp[104]*Hs[112]*Hs[118] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[337]*Hs[113]*Hs[118] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[338]*Hs[113]*Hs[118] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[338]*Hs[113]*Hs[118] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*G2sp[338]*Hs[113]*Hs[118] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*G2sp[340]*Hs[113]*Hs[118] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[344]*Hs[113]*Hs[118] - 2*bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[344]*Hs[113]*Hs[118] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[344]*Hs[113]*Hs[118] + 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17]*Gsp[97]*Hs[113]*Hs[118] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18]*Gsp[97]*Hs[113]*Hs[118] - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18]*Gsp[97]*Hs[113]*Hs[118] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18]*Gsp[97]*Hs[113]*Hs[118] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]*Gsp[97]*Hs[113]*Hs[118] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17]*Gsp[98]*Hs[113]*Hs[118] - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17]*Gsp[98]*Hs[113]*Hs[118] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[17]*Gsp[98]*Hs[113]*Hs[118] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18]*Gsp[98]*Hs[113]*Hs[118] - 4*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18]*Gsp[98]*Hs[113]*Hs[118] + 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18]*Gsp[98]*Hs[113]*Hs[118] - 4*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18]*Gsp[98]*Hs[113]*Hs[118] + 4*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18]*Gsp[98]*Hs[113]*Hs[118] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,3)*pow(zbar,aalpha)*Gsp[18]*Gsp[98]*Hs[113]*Hs[118] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]*Gsp[98]*Hs[113]*Hs[118] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]*Gsp[98]*Hs[113]*Hs[118] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[24]*Gsp[98]*Hs[113]*Hs[118] + 4*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20]*Gsp[100]*Hs[113]*Hs[118] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[24]*Gsp[100]*Hs[113]*Hs[118] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17]*Gsp[104]*Hs[113]*Hs[118] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18]*Gsp[104]*Hs[113]*Hs[118] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18]*Gsp[104]*Hs[113]*Hs[118] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18]*Gsp[104]*Hs[113]*Hs[118] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20]*Gsp[104]*Hs[113]*Hs[118] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24]*Gsp[104]*Hs[113]*Hs[118] - 2*bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24]*Gsp[104]*Hs[113]*Hs[118] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]*Gsp[104]*Hs[113]*Hs[118] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[577]*Hs[114]*Hs[118] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[578]*Hs[114]*Hs[118] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[578]*Hs[114]*Hs[118] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*G2sp[578]*Hs[114]*Hs[118] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*G2sp[580]*Hs[114]*Hs[118] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[584]*Hs[114]*Hs[118] - 2*bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[584]*Hs[114]*Hs[118] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[584]*Hs[114]*Hs[118] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha)*Gsp[97]*Hs[114]*Hs[118] + 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33]*Gsp[97]*Hs[114]*Hs[118] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34]*Gsp[97]*Hs[114]*Hs[118] - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34]*Gsp[97]*Hs[114]*Hs[118] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34]*Gsp[97]*Hs[114]*Hs[118] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]*Gsp[97]*Hs[114]*Hs[118] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha)*Gsp[98]*Hs[114]*Hs[118] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha)*Gsp[98]*Hs[114]*Hs[118] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*rrhoa*pow(zbar,aalpha)*Gsp[98]*Hs[114]*Hs[118] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33]*Gsp[98]*Hs[114]*Hs[118] - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33]*Gsp[98]*Hs[114]*Hs[118] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[33]*Gsp[98]*Hs[114]*Hs[118] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34]*Gsp[98]*Hs[114]*Hs[118] - 4*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34]*Gsp[98]*Hs[114]*Hs[118] + 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34]*Gsp[98]*Hs[114]*Hs[118] - 4*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34]*Gsp[98]*Hs[114]*Hs[118] + 4*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34]*Gsp[98]*Hs[114]*Hs[118] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,3)*pow(zbar,aalpha)*Gsp[34]*Gsp[98]*Hs[114]*Hs[118] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]*Gsp[98]*Hs[114]*Hs[118] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]*Gsp[98]*Hs[114]*Hs[118] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[40]*Gsp[98]*Hs[114]*Hs[118] + 4*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36]*Gsp[100]*Hs[114]*Hs[118] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[40]*Gsp[100]*Hs[114]*Hs[118] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha)*Gsp[104]*Hs[114]*Hs[118] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33]*Gsp[104]*Hs[114]*Hs[118] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34]*Gsp[104]*Hs[114]*Hs[118] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34]*Gsp[104]*Hs[114]*Hs[118] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34]*Gsp[104]*Hs[114]*Hs[118] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36]*Gsp[104]*Hs[114]*Hs[118] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40]*Gsp[104]*Hs[114]*Hs[118] - 2*bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40]*Gsp[104]*Hs[114]*Hs[118] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]*Gsp[104]*Hs[114]*Hs[118] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[817]*Hs[115]*Hs[118] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[818]*Hs[115]*Hs[118] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[818]*Hs[115]*Hs[118] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*G2sp[818]*Hs[115]*Hs[118] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*G2sp[820]*Hs[115]*Hs[118] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[824]*Hs[115]*Hs[118] - 2*bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[824]*Hs[115]*Hs[118] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[824]*Hs[115]*Hs[118] + 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha)*Gsp[97]*Hs[115]*Hs[118] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha)*Gsp[97]*Hs[115]*Hs[118] + 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49]*Gsp[97]*Hs[115]*Hs[118] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50]*Gsp[97]*Hs[115]*Hs[118] - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50]*Gsp[97]*Hs[115]*Hs[118] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50]*Gsp[97]*Hs[115]*Hs[118] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]*Gsp[97]*Hs[115]*Hs[118] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha)*Gsp[98]*Hs[115]*Hs[118] - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha)*Gsp[98]*Hs[115]*Hs[118] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*rrhoz*pow(zbar,aalpha)*Gsp[98]*Hs[115]*Hs[118] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha)*Gsp[98]*Hs[115]*Hs[118] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha)*Gsp[98]*Hs[115]*Hs[118] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*rrho*rrhoz*pow(zbar,aalpha)*Gsp[98]*Hs[115]*Hs[118] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49]*Gsp[98]*Hs[115]*Hs[118] - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49]*Gsp[98]*Hs[115]*Hs[118] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[49]*Gsp[98]*Hs[115]*Hs[118] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50]*Gsp[98]*Hs[115]*Hs[118] - 4*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50]*Gsp[98]*Hs[115]*Hs[118] + 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50]*Gsp[98]*Hs[115]*Hs[118] - 4*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50]*Gsp[98]*Hs[115]*Hs[118] + 4*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50]*Gsp[98]*Hs[115]*Hs[118] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,3)*pow(zbar,aalpha)*Gsp[50]*Gsp[98]*Hs[115]*Hs[118] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]*Gsp[98]*Hs[115]*Hs[118] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]*Gsp[98]*Hs[115]*Hs[118] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[56]*Gsp[98]*Hs[115]*Hs[118] + 4*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2)*Gsp[100]*Hs[115]*Hs[118] - 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrho*rrhoz*pow(zbar,2)*Gsp[100]*Hs[115]*Hs[118] + 4*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52]*Gsp[100]*Hs[115]*Hs[118] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[56]*Gsp[100]*Hs[115]*Hs[118] - 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz*Gsp[104]*Hs[115]*Hs[118] + 2*bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz*Gsp[104]*Hs[115]*Hs[118] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2)*Gsp[104]*Hs[115]*Hs[118] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha)*Gsp[104]*Hs[115]*Hs[118] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha)*Gsp[104]*Hs[115]*Hs[118] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49]*Gsp[104]*Hs[115]*Hs[118] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50]*Gsp[104]*Hs[115]*Hs[118] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50]*Gsp[104]*Hs[115]*Hs[118] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50]*Gsp[104]*Hs[115]*Hs[118] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52]*Gsp[104]*Hs[115]*Hs[118] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56]*Gsp[104]*Hs[115]*Hs[118] - 2*bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56]*Gsp[104]*Hs[115]*Hs[118] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]*Gsp[104]*Hs[115]*Hs[118] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[1057]*Hs[116]*Hs[118] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[1058]*Hs[116]*Hs[118] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[1058]*Hs[116]*Hs[118] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*G2sp[1058]*Hs[116]*Hs[118] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*G2sp[1060]*Hs[116]*Hs[118] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[1064]*Hs[116]*Hs[118] - 2*bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[1064]*Hs[116]*Hs[118] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[1064]*Hs[116]*Hs[118] + 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65]*Gsp[97]*Hs[116]*Hs[118] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66]*Gsp[97]*Hs[116]*Hs[118] - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66]*Gsp[97]*Hs[116]*Hs[118] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66]*Gsp[97]*Hs[116]*Hs[118] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]*Gsp[97]*Hs[116]*Hs[118] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65]*Gsp[98]*Hs[116]*Hs[118] - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65]*Gsp[98]*Hs[116]*Hs[118] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[65]*Gsp[98]*Hs[116]*Hs[118] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66]*Gsp[98]*Hs[116]*Hs[118] - 4*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66]*Gsp[98]*Hs[116]*Hs[118] + 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66]*Gsp[98]*Hs[116]*Hs[118] - 4*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66]*Gsp[98]*Hs[116]*Hs[118] + 4*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66]*Gsp[98]*Hs[116]*Hs[118] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,3)*pow(zbar,aalpha)*Gsp[66]*Gsp[98]*Hs[116]*Hs[118] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]*Gsp[98]*Hs[116]*Hs[118] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]*Gsp[98]*Hs[116]*Hs[118] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[72]*Gsp[98]*Hs[116]*Hs[118] + 4*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68]*Gsp[100]*Hs[116]*Hs[118] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[72]*Gsp[100]*Hs[116]*Hs[118] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65]*Gsp[104]*Hs[116]*Hs[118] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66]*Gsp[104]*Hs[116]*Hs[118] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66]*Gsp[104]*Hs[116]*Hs[118] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66]*Gsp[104]*Hs[116]*Hs[118] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68]*Gsp[104]*Hs[116]*Hs[118] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72]*Gsp[104]*Hs[116]*Hs[118] - 2*bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72]*Gsp[104]*Hs[116]*Hs[118] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]*Gsp[104]*Hs[116]*Hs[118] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[1297]*Hs[117]*Hs[118] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[1298]*Hs[117]*Hs[118] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[1298]*Hs[117]*Hs[118] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*G2sp[1298]*Hs[117]*Hs[118] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*G2sp[1300]*Hs[117]*Hs[118] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[1304]*Hs[117]*Hs[118] - 2*bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[1304]*Hs[117]*Hs[118] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[1304]*Hs[117]*Hs[118] + 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81]*Gsp[97]*Hs[117]*Hs[118] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82]*Gsp[97]*Hs[117]*Hs[118] - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82]*Gsp[97]*Hs[117]*Hs[118] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82]*Gsp[97]*Hs[117]*Hs[118] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]*Gsp[97]*Hs[117]*Hs[118] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81]*Gsp[98]*Hs[117]*Hs[118] - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81]*Gsp[98]*Hs[117]*Hs[118] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[81]*Gsp[98]*Hs[117]*Hs[118] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82]*Gsp[98]*Hs[117]*Hs[118] - 4*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82]*Gsp[98]*Hs[117]*Hs[118] + 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82]*Gsp[98]*Hs[117]*Hs[118] - 4*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82]*Gsp[98]*Hs[117]*Hs[118] + 4*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82]*Gsp[98]*Hs[117]*Hs[118] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,3)*pow(zbar,aalpha)*Gsp[82]*Gsp[98]*Hs[117]*Hs[118] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]*Gsp[98]*Hs[117]*Hs[118] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]*Gsp[98]*Hs[117]*Hs[118] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[88]*Gsp[98]*Hs[117]*Hs[118] + 4*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84]*Gsp[100]*Hs[117]*Hs[118] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[88]*Gsp[100]*Hs[117]*Hs[118] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81]*Gsp[104]*Hs[117]*Hs[118] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82]*Gsp[104]*Hs[117]*Hs[118] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82]*Gsp[104]*Hs[117]*Hs[118] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82]*Gsp[104]*Hs[117]*Hs[118] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84]*Gsp[104]*Hs[117]*Hs[118] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88]*Gsp[104]*Hs[117]*Hs[118] - 2*bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88]*Gsp[104]*Hs[117]*Hs[118] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]*Gsp[104]*Hs[117]*Hs[118] + aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[1537]*pow(Hs[118],2) + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[1538]*pow(Hs[118],2) - aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[1538]*pow(Hs[118],2) - abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*G2sp[1538]*pow(Hs[118],2) + bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*G2sp[1540]*pow(Hs[118],2) + bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[1544]*pow(Hs[118],2) - bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[1544]*pow(Hs[118],2) + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[1544]*pow(Hs[118],2) + pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*pow(Gsp[97],2)*pow(Hs[118],2) + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97]*Gsp[98]*pow(Hs[118],2) - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97]*Gsp[98]*pow(Hs[118],2) - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[97]*Gsp[98]*pow(Hs[118],2) + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*pow(Gsp[98],2)*pow(Hs[118],2) - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*pow(Gsp[98],2)*pow(Hs[118],2) + pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*pow(Gsp[98],2)*pow(Hs[118],2) - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*pow(Gsp[98],2)*pow(Hs[118],2) + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*pow(Gsp[98],2)*pow(Hs[118],2) + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,3)*pow(zbar,aalpha)*pow(Gsp[98],2)*pow(Hs[118],2) + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*pow(Gsp[100],2)*pow(Hs[118],2) + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97]*Gsp[104]*pow(Hs[118],2) + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98]*Gsp[104]*pow(Hs[118],2) - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98]*Gsp[104]*pow(Hs[118],2) - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98]*Gsp[104]*pow(Hs[118],2) + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100]*Gsp[104]*pow(Hs[118],2) + bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*pow(Gsp[104],2)*pow(Hs[118],2) - bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*pow(Gsp[104],2)*pow(Hs[118],2) + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*pow(Gsp[104],2)*pow(Hs[118],2) + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[1905]*Hs[119] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[1906]*Hs[119] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[1906]*Hs[119] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*G2sp[1906]*Hs[119] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*G2sp[1908]*Hs[119] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[1912]*Hs[119] - 2*bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[1912]*Hs[119] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[1912]*Hs[119] + 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113]*Gsp[225]*Hs[119] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114]*Gsp[225]*Hs[119] - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114]*Gsp[225]*Hs[119] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114]*Gsp[225]*Hs[119] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]*Gsp[225]*Hs[119] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113]*Gsp[226]*Hs[119] - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113]*Gsp[226]*Hs[119] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[113]*Gsp[226]*Hs[119] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114]*Gsp[226]*Hs[119] - 4*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114]*Gsp[226]*Hs[119] + 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114]*Gsp[226]*Hs[119] - 4*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114]*Gsp[226]*Hs[119] + 4*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114]*Gsp[226]*Hs[119] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,3)*pow(zbar,aalpha)*Gsp[114]*Gsp[226]*Hs[119] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]*Gsp[226]*Hs[119] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]*Gsp[226]*Hs[119] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[120]*Gsp[226]*Hs[119] + 4*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116]*Gsp[228]*Hs[119] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[120]*Gsp[228]*Hs[119] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113]*Gsp[232]*Hs[119] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114]*Gsp[232]*Hs[119] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114]*Gsp[232]*Hs[119] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114]*Gsp[232]*Hs[119] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116]*Gsp[232]*Hs[119] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120]*Gsp[232]*Hs[119] - 2*bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120]*Gsp[232]*Hs[119] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]*Gsp[232]*Hs[119] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[113]*Hs[112]*Hs[119] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[114]*Hs[112]*Hs[119] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[114]*Hs[112]*Hs[119] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*G2sp[114]*Hs[112]*Hs[119] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*G2sp[116]*Hs[112]*Hs[119] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[120]*Hs[112]*Hs[119] - 2*bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[120]*Hs[112]*Hs[119] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[120]*Hs[112]*Hs[119] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113]*Hs[112]*Hs[119] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[113]*Hs[112]*Hs[119] + 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1]*Gsp[113]*Hs[112]*Hs[119] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2]*Gsp[113]*Hs[112]*Hs[119] - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2]*Gsp[113]*Hs[112]*Hs[119] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2]*Gsp[113]*Hs[112]*Hs[119] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]*Gsp[113]*Hs[112]*Hs[119] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114]*Hs[112]*Hs[119] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114]*Hs[112]*Hs[119] + 4*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114]*Hs[112]*Hs[119] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114]*Hs[112]*Hs[119] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,3)*pow(zbar,aalpha)*Gsp[114]*Hs[112]*Hs[119] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1]*Gsp[114]*Hs[112]*Hs[119] - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1]*Gsp[114]*Hs[112]*Hs[119] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[1]*Gsp[114]*Hs[112]*Hs[119] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2]*Gsp[114]*Hs[112]*Hs[119] - 4*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2]*Gsp[114]*Hs[112]*Hs[119] + 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2]*Gsp[114]*Hs[112]*Hs[119] - 4*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2]*Gsp[114]*Hs[112]*Hs[119] + 4*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2]*Gsp[114]*Hs[112]*Hs[119] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,3)*pow(zbar,aalpha)*Gsp[2]*Gsp[114]*Hs[112]*Hs[119] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]*Gsp[114]*Hs[112]*Hs[119] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]*Gsp[114]*Hs[112]*Hs[119] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[8]*Gsp[114]*Hs[112]*Hs[119] - 4*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116]*Hs[112]*Hs[119] + 4*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4]*Gsp[116]*Hs[112]*Hs[119] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[8]*Gsp[116]*Hs[112]*Hs[119] - 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[120]*Hs[112]*Hs[119] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]*Hs[112]*Hs[119] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[120]*Hs[112]*Hs[119] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1]*Gsp[120]*Hs[112]*Hs[119] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2]*Gsp[120]*Hs[112]*Hs[119] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2]*Gsp[120]*Hs[112]*Hs[119] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2]*Gsp[120]*Hs[112]*Hs[119] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4]*Gsp[120]*Hs[112]*Hs[119] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8]*Gsp[120]*Hs[112]*Hs[119] - 2*bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8]*Gsp[120]*Hs[112]*Hs[119] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]*Gsp[120]*Hs[112]*Hs[119] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[353]*Hs[113]*Hs[119] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[354]*Hs[113]*Hs[119] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[354]*Hs[113]*Hs[119] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*G2sp[354]*Hs[113]*Hs[119] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*G2sp[356]*Hs[113]*Hs[119] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[360]*Hs[113]*Hs[119] - 2*bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[360]*Hs[113]*Hs[119] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[360]*Hs[113]*Hs[119] + 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17]*Gsp[113]*Hs[113]*Hs[119] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18]*Gsp[113]*Hs[113]*Hs[119] - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18]*Gsp[113]*Hs[113]*Hs[119] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18]*Gsp[113]*Hs[113]*Hs[119] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]*Gsp[113]*Hs[113]*Hs[119] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17]*Gsp[114]*Hs[113]*Hs[119] - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17]*Gsp[114]*Hs[113]*Hs[119] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[17]*Gsp[114]*Hs[113]*Hs[119] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18]*Gsp[114]*Hs[113]*Hs[119] - 4*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18]*Gsp[114]*Hs[113]*Hs[119] + 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18]*Gsp[114]*Hs[113]*Hs[119] - 4*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18]*Gsp[114]*Hs[113]*Hs[119] + 4*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18]*Gsp[114]*Hs[113]*Hs[119] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,3)*pow(zbar,aalpha)*Gsp[18]*Gsp[114]*Hs[113]*Hs[119] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]*Gsp[114]*Hs[113]*Hs[119] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]*Gsp[114]*Hs[113]*Hs[119] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[24]*Gsp[114]*Hs[113]*Hs[119] + 4*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20]*Gsp[116]*Hs[113]*Hs[119] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[24]*Gsp[116]*Hs[113]*Hs[119] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17]*Gsp[120]*Hs[113]*Hs[119] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18]*Gsp[120]*Hs[113]*Hs[119] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18]*Gsp[120]*Hs[113]*Hs[119] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18]*Gsp[120]*Hs[113]*Hs[119] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20]*Gsp[120]*Hs[113]*Hs[119] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24]*Gsp[120]*Hs[113]*Hs[119] - 2*bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24]*Gsp[120]*Hs[113]*Hs[119] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]*Gsp[120]*Hs[113]*Hs[119] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[593]*Hs[114]*Hs[119] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[594]*Hs[114]*Hs[119] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[594]*Hs[114]*Hs[119] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*G2sp[594]*Hs[114]*Hs[119] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*G2sp[596]*Hs[114]*Hs[119] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[600]*Hs[114]*Hs[119] - 2*bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[600]*Hs[114]*Hs[119] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[600]*Hs[114]*Hs[119] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha)*Gsp[113]*Hs[114]*Hs[119] + 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33]*Gsp[113]*Hs[114]*Hs[119] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34]*Gsp[113]*Hs[114]*Hs[119] - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34]*Gsp[113]*Hs[114]*Hs[119] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34]*Gsp[113]*Hs[114]*Hs[119] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]*Gsp[113]*Hs[114]*Hs[119] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha)*Gsp[114]*Hs[114]*Hs[119] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha)*Gsp[114]*Hs[114]*Hs[119] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*rrhoa*pow(zbar,aalpha)*Gsp[114]*Hs[114]*Hs[119] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33]*Gsp[114]*Hs[114]*Hs[119] - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33]*Gsp[114]*Hs[114]*Hs[119] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[33]*Gsp[114]*Hs[114]*Hs[119] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34]*Gsp[114]*Hs[114]*Hs[119] - 4*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34]*Gsp[114]*Hs[114]*Hs[119] + 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34]*Gsp[114]*Hs[114]*Hs[119] - 4*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34]*Gsp[114]*Hs[114]*Hs[119] + 4*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34]*Gsp[114]*Hs[114]*Hs[119] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,3)*pow(zbar,aalpha)*Gsp[34]*Gsp[114]*Hs[114]*Hs[119] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]*Gsp[114]*Hs[114]*Hs[119] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]*Gsp[114]*Hs[114]*Hs[119] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[40]*Gsp[114]*Hs[114]*Hs[119] + 4*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36]*Gsp[116]*Hs[114]*Hs[119] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[40]*Gsp[116]*Hs[114]*Hs[119] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha)*Gsp[120]*Hs[114]*Hs[119] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33]*Gsp[120]*Hs[114]*Hs[119] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34]*Gsp[120]*Hs[114]*Hs[119] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34]*Gsp[120]*Hs[114]*Hs[119] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34]*Gsp[120]*Hs[114]*Hs[119] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36]*Gsp[120]*Hs[114]*Hs[119] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40]*Gsp[120]*Hs[114]*Hs[119] - 2*bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40]*Gsp[120]*Hs[114]*Hs[119] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]*Gsp[120]*Hs[114]*Hs[119] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[833]*Hs[115]*Hs[119] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[834]*Hs[115]*Hs[119] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[834]*Hs[115]*Hs[119] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*G2sp[834]*Hs[115]*Hs[119] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*G2sp[836]*Hs[115]*Hs[119] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[840]*Hs[115]*Hs[119] - 2*bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[840]*Hs[115]*Hs[119] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[840]*Hs[115]*Hs[119] + 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha)*Gsp[113]*Hs[115]*Hs[119] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha)*Gsp[113]*Hs[115]*Hs[119] + 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49]*Gsp[113]*Hs[115]*Hs[119] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50]*Gsp[113]*Hs[115]*Hs[119] - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50]*Gsp[113]*Hs[115]*Hs[119] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50]*Gsp[113]*Hs[115]*Hs[119] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]*Gsp[113]*Hs[115]*Hs[119] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha)*Gsp[114]*Hs[115]*Hs[119] - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha)*Gsp[114]*Hs[115]*Hs[119] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*rrhoz*pow(zbar,aalpha)*Gsp[114]*Hs[115]*Hs[119] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha)*Gsp[114]*Hs[115]*Hs[119] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha)*Gsp[114]*Hs[115]*Hs[119] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*rrho*rrhoz*pow(zbar,aalpha)*Gsp[114]*Hs[115]*Hs[119] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49]*Gsp[114]*Hs[115]*Hs[119] - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49]*Gsp[114]*Hs[115]*Hs[119] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[49]*Gsp[114]*Hs[115]*Hs[119] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50]*Gsp[114]*Hs[115]*Hs[119] - 4*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50]*Gsp[114]*Hs[115]*Hs[119] + 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50]*Gsp[114]*Hs[115]*Hs[119] - 4*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50]*Gsp[114]*Hs[115]*Hs[119] + 4*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50]*Gsp[114]*Hs[115]*Hs[119] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,3)*pow(zbar,aalpha)*Gsp[50]*Gsp[114]*Hs[115]*Hs[119] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]*Gsp[114]*Hs[115]*Hs[119] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]*Gsp[114]*Hs[115]*Hs[119] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[56]*Gsp[114]*Hs[115]*Hs[119] + 4*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2)*Gsp[116]*Hs[115]*Hs[119] - 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrho*rrhoz*pow(zbar,2)*Gsp[116]*Hs[115]*Hs[119] + 4*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52]*Gsp[116]*Hs[115]*Hs[119] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[56]*Gsp[116]*Hs[115]*Hs[119] - 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz*Gsp[120]*Hs[115]*Hs[119] + 2*bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz*Gsp[120]*Hs[115]*Hs[119] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2)*Gsp[120]*Hs[115]*Hs[119] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha)*Gsp[120]*Hs[115]*Hs[119] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha)*Gsp[120]*Hs[115]*Hs[119] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49]*Gsp[120]*Hs[115]*Hs[119] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50]*Gsp[120]*Hs[115]*Hs[119] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50]*Gsp[120]*Hs[115]*Hs[119] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50]*Gsp[120]*Hs[115]*Hs[119] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52]*Gsp[120]*Hs[115]*Hs[119] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56]*Gsp[120]*Hs[115]*Hs[119] - 2*bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56]*Gsp[120]*Hs[115]*Hs[119] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]*Gsp[120]*Hs[115]*Hs[119] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[1073]*Hs[116]*Hs[119] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[1074]*Hs[116]*Hs[119] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[1074]*Hs[116]*Hs[119] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*G2sp[1074]*Hs[116]*Hs[119] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*G2sp[1076]*Hs[116]*Hs[119] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[1080]*Hs[116]*Hs[119] - 2*bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[1080]*Hs[116]*Hs[119] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[1080]*Hs[116]*Hs[119] + 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65]*Gsp[113]*Hs[116]*Hs[119] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66]*Gsp[113]*Hs[116]*Hs[119] - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66]*Gsp[113]*Hs[116]*Hs[119] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66]*Gsp[113]*Hs[116]*Hs[119] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]*Gsp[113]*Hs[116]*Hs[119] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65]*Gsp[114]*Hs[116]*Hs[119] - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65]*Gsp[114]*Hs[116]*Hs[119] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[65]*Gsp[114]*Hs[116]*Hs[119] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66]*Gsp[114]*Hs[116]*Hs[119] - 4*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66]*Gsp[114]*Hs[116]*Hs[119] + 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66]*Gsp[114]*Hs[116]*Hs[119] - 4*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66]*Gsp[114]*Hs[116]*Hs[119] + 4*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66]*Gsp[114]*Hs[116]*Hs[119] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,3)*pow(zbar,aalpha)*Gsp[66]*Gsp[114]*Hs[116]*Hs[119] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]*Gsp[114]*Hs[116]*Hs[119] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]*Gsp[114]*Hs[116]*Hs[119] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[72]*Gsp[114]*Hs[116]*Hs[119] + 4*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68]*Gsp[116]*Hs[116]*Hs[119] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[72]*Gsp[116]*Hs[116]*Hs[119] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65]*Gsp[120]*Hs[116]*Hs[119] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66]*Gsp[120]*Hs[116]*Hs[119] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66]*Gsp[120]*Hs[116]*Hs[119] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66]*Gsp[120]*Hs[116]*Hs[119] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68]*Gsp[120]*Hs[116]*Hs[119] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72]*Gsp[120]*Hs[116]*Hs[119] - 2*bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72]*Gsp[120]*Hs[116]*Hs[119] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]*Gsp[120]*Hs[116]*Hs[119] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[1313]*Hs[117]*Hs[119] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[1314]*Hs[117]*Hs[119] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[1314]*Hs[117]*Hs[119] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*G2sp[1314]*Hs[117]*Hs[119] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*G2sp[1316]*Hs[117]*Hs[119] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[1320]*Hs[117]*Hs[119] - 2*bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[1320]*Hs[117]*Hs[119] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[1320]*Hs[117]*Hs[119] + 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81]*Gsp[113]*Hs[117]*Hs[119] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82]*Gsp[113]*Hs[117]*Hs[119] - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82]*Gsp[113]*Hs[117]*Hs[119] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82]*Gsp[113]*Hs[117]*Hs[119] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]*Gsp[113]*Hs[117]*Hs[119] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81]*Gsp[114]*Hs[117]*Hs[119] - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81]*Gsp[114]*Hs[117]*Hs[119] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[81]*Gsp[114]*Hs[117]*Hs[119] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82]*Gsp[114]*Hs[117]*Hs[119] - 4*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82]*Gsp[114]*Hs[117]*Hs[119] + 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82]*Gsp[114]*Hs[117]*Hs[119] - 4*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82]*Gsp[114]*Hs[117]*Hs[119] + 4*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82]*Gsp[114]*Hs[117]*Hs[119] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,3)*pow(zbar,aalpha)*Gsp[82]*Gsp[114]*Hs[117]*Hs[119] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]*Gsp[114]*Hs[117]*Hs[119] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]*Gsp[114]*Hs[117]*Hs[119] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[88]*Gsp[114]*Hs[117]*Hs[119] + 4*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84]*Gsp[116]*Hs[117]*Hs[119] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[88]*Gsp[116]*Hs[117]*Hs[119] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81]*Gsp[120]*Hs[117]*Hs[119] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82]*Gsp[120]*Hs[117]*Hs[119] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82]*Gsp[120]*Hs[117]*Hs[119] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82]*Gsp[120]*Hs[117]*Hs[119] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84]*Gsp[120]*Hs[117]*Hs[119] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88]*Gsp[120]*Hs[117]*Hs[119] - 2*bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88]*Gsp[120]*Hs[117]*Hs[119] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]*Gsp[120]*Hs[117]*Hs[119] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[1553]*Hs[118]*Hs[119] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[1554]*Hs[118]*Hs[119] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[1554]*Hs[118]*Hs[119] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*G2sp[1554]*Hs[118]*Hs[119] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*G2sp[1556]*Hs[118]*Hs[119] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[1560]*Hs[118]*Hs[119] - 2*bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[1560]*Hs[118]*Hs[119] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[1560]*Hs[118]*Hs[119] + 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97]*Gsp[113]*Hs[118]*Hs[119] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98]*Gsp[113]*Hs[118]*Hs[119] - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98]*Gsp[113]*Hs[118]*Hs[119] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98]*Gsp[113]*Hs[118]*Hs[119] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]*Gsp[113]*Hs[118]*Hs[119] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97]*Gsp[114]*Hs[118]*Hs[119] - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97]*Gsp[114]*Hs[118]*Hs[119] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[97]*Gsp[114]*Hs[118]*Hs[119] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98]*Gsp[114]*Hs[118]*Hs[119] - 4*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98]*Gsp[114]*Hs[118]*Hs[119] + 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98]*Gsp[114]*Hs[118]*Hs[119] - 4*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98]*Gsp[114]*Hs[118]*Hs[119] + 4*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98]*Gsp[114]*Hs[118]*Hs[119] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,3)*pow(zbar,aalpha)*Gsp[98]*Gsp[114]*Hs[118]*Hs[119] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]*Gsp[114]*Hs[118]*Hs[119] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]*Gsp[114]*Hs[118]*Hs[119] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[104]*Gsp[114]*Hs[118]*Hs[119] + 4*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100]*Gsp[116]*Hs[118]*Hs[119] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[104]*Gsp[116]*Hs[118]*Hs[119] + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97]*Gsp[120]*Hs[118]*Hs[119] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98]*Gsp[120]*Hs[118]*Hs[119] - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98]*Gsp[120]*Hs[118]*Hs[119] - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98]*Gsp[120]*Hs[118]*Hs[119] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100]*Gsp[120]*Hs[118]*Hs[119] + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104]*Gsp[120]*Hs[118]*Hs[119] - 2*bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104]*Gsp[120]*Hs[118]*Hs[119] + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]*Gsp[120]*Hs[118]*Hs[119] + aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[1793]*pow(Hs[119],2) + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[1794]*pow(Hs[119],2) - aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[1794]*pow(Hs[119],2) - abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*G2sp[1794]*pow(Hs[119],2) + bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*G2sp[1796]*pow(Hs[119],2) + bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[1800]*pow(Hs[119],2) - bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*G2sp[1800]*pow(Hs[119],2) + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*G2sp[1800]*pow(Hs[119],2) + pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*pow(Gsp[113],2)*pow(Hs[119],2) + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113]*Gsp[114]*pow(Hs[119],2) - 2*pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113]*Gsp[114]*pow(Hs[119],2) - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[113]*Gsp[114]*pow(Hs[119],2) + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*pow(Gsp[114],2)*pow(Hs[119],2) - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*pow(Gsp[114],2)*pow(Hs[119],2) + pow(aalpha,2)*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*pow(Gsp[114],2)*pow(Hs[119],2) - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*pow(Gsp[114],2)*pow(Hs[119],2) + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*pow(Gsp[114],2)*pow(Hs[119],2) + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,3)*pow(zbar,aalpha)*pow(Gsp[114],2)*pow(Hs[119],2) + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*pow(Gsp[116],2)*pow(Hs[119],2) + 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113]*Gsp[120]*pow(Hs[119],2) + 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114]*Gsp[120]*pow(Hs[119],2) - 2*aalpha*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114]*Gsp[120]*pow(Hs[119],2) - 2*abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114]*Gsp[120]*pow(Hs[119],2) + 2*bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116]*Gsp[120]*pow(Hs[119],2) + bbeta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*pow(Gsp[120],2)*pow(Hs[119],2) - bbeta*ddelta*pow(E,xss[0] + yss[8])*pow(pow(E,yss[2]),aalpha + eeta)*pow(Gsp[120],2)*pow(Hs[119],2) + abar*bbeta*pow(E,yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*pow(Gsp[120],2)*pow(Hs[119],2) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*kkappa*pow(zbar,rrho)*pow(Gs[230],2)*yss[9])))/(pow(E,xss[0])*pow(zbar,rrho));
	Ncc_sp_s[5]=-(Pssp*pow(Gs[230],2)) + iiota*Pssp*zbar*pow(Hs[112] + Hs[115],2) + 2*(dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-Gs[230] + iiota*zbar*(Hs[112] + Hs[115]));
	Ncc_sp_s[6]=pow(pow(E,yss[1]),-1 + oomega)*pow(-1 + oomega,2)*Pssp*pow(Gs[225],2) - pow(E,yss[7])*Pssp*pow(Gs[231],2) + 2*(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[225] - pow(E,yss[7])*Gs[231])*(dP2ssp*Gs[233] + dP1ssp*Gs[234]);
	Ncc_sp_s[7]=-(pow(E,yss[0])*Pssp*pow(Gs[224],2)) + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*pow(Gs[225],2) - 2*aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Gs[226] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*pow(Gs[226],2) - pow(E,yss[3])*Pssp*pow(Gs[227],2) + 2*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[114] - 2*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[114] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*pow(Hs[114],2) + 2*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[115] - 2*aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[115] + 2*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[114]*Hs[115] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*pow(Hs[115],2) - pow(E,yss[2])*pbar*Pssp*pow(Gs[226] + Hs[116],2) - 2*pphi*Pssp*Gs[229]*(pow(E,yss[1] + yss[7])*(Gs[225] + Gs[231]) + pow(E,yss[2])*pbar*(Gs[226] + Hs[116])) - pow(E,yss[11])*ebar*Pssp*pow(Hs[118],2) - pow(E,yss[1] + yss[7])*pphi*Pssp*pow(Gs[225] + Gs[231],2)*yss[5] - pow(E,yss[2])*pbar*pphi*Pssp*pow(Gs[226] + Hs[116],2)*yss[5] - (2*Pssp*zbar*pow(Gs[229],2)*xss[1])/pow(1 + yss[5],3) + (2*Pssp*zbar*Gs[229]*Hs[113])/pow(1 + yss[5],2) + (2*Pssp*zbar*Gs[229]*Hs[115]*xss[1])/pow(1 + yss[5],2) - (2*Pssp*zbar*Hs[113]*Hs[115])/(1 + yss[5]) - (Pssp*zbar*pow(Hs[115],2)*xss[1])/(1 + yss[5]) + 2*(dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-(pow(E,yss[0])*Gs[224]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[225] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[226] - pow(E,yss[3])*Gs[227] - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[229] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[115] - pow(E,yss[2])*pbar*(Gs[226] + Hs[116]) - pow(E,yss[11])*ebar*Hs[118] - pphi*(pow(E,yss[1] + yss[7])*(Gs[225] + Gs[231]) + pow(E,yss[2])*pbar*(Gs[226] + Hs[116]))*yss[5] + (zbar*Gs[229]*xss[1])/pow(1 + yss[5],2) - (zbar*Hs[113])/(1 + yss[5]) - (zbar*Hs[115]*xss[1])/(1 + yss[5]));
	Ncc_sp_s[8]=pow(E,yss[3])*Pssp*pow(Gs[227],2) - pow(E,xss[0])*Pssp*zbar*pow(Hs[112] + Hs[115],2) - pow(E,xss[0])*iiota*Pssp*pow(zbar,2)*pow(Hs[112] + Hs[115],2) + 2*(dP2ssp*Gs[233] + dP1ssp*Gs[234])*(pow(E,yss[3])*Gs[227] - pow(E,xss[0])*zbar*(Hs[112] + Hs[115]));
	Ncc_sp_s[9]=pow(E,xss[0])*kkappa*Pssp*zbar*pow(Gs[230] + Hs[112] + Hs[115],2) - 2*pphi*Pssp*Gs[229]*(pow(E,yss[1] + yss[7])*(Gs[225] + Gs[231]) + pow(E,yss[2])*pbar*(Gs[226] + Hs[116])) + (2*Pssp*zbar*pow(Gs[229],2)*xss[1])/pow(1 + yss[5],3) - (2*Pssp*zbar*Gs[229]*Hs[113])/pow(1 + yss[5],2) - (2*Pssp*zbar*Gs[229]*Hs[115]*xss[1])/pow(1 + yss[5],2) + (2*Pssp*zbar*Hs[113]*Hs[115])/(1 + yss[5]) + (Pssp*zbar*pow(Hs[115],2)*xss[1])/(1 + yss[5]) - pow(E,yss[1] + yss[7])*pphi*Pssp*pow(Gs[225] + Gs[231],2)*(1 + yss[5]) - pow(E,yss[2])*pbar*pphi*Pssp*pow(Gs[226] + Hs[116],2)*(1 + yss[5]) + 2*(dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[229]) - Gs[234] + pow(E,xss[0])*kkappa*zbar*(Gs[230] + Hs[112] + Hs[115]) - (zbar*Gs[229]*xss[1])/pow(1 + yss[5],2) + (zbar*Hs[113])/(1 + yss[5]) + (zbar*Hs[115]*xss[1])/(1 + yss[5]) - pphi*(pow(E,yss[1] + yss[7])*(Gs[225] + Gs[231]) + pow(E,yss[2])*pbar*(Gs[226] + Hs[116]))*(1 + yss[5]));
	Ncc_sp_s[10]=2*(dP2ssp*Gs[233] + dP1ssp*Gs[234])*((-1 + nnus)*Gs[233] + nnus*Gs[234] + (-varphibar + varphis)*yss[9] + (-varphibar + varphis)*yss[10]);
	Ncc_sp_s[11]=pow(E,bbar - xss[1])*ppsir*Pssp*pow(Hs[113],2) + 2*(dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-Gs[229] - pow(E,bbar - xss[1])*ppsir*Hs[113] + Hs[117]);
	Ncc_sp_s[12]=-(pow(E,xss[0])*(Gs[228] - Hs[112])*(2*dP2ssp*Gs[233] + 2*dP1ssp*Gs[234] + Pssp*(Gs[228] + Hs[112])));
	Ncc_sp_s[13]=-(pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*pow(Gs[225],2)) + 2*aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Gs[226] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*pow(Gs[226],2) + pow(E,yss[11])*Pssp*pow(Gs[235],2) - 2*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[114] + 2*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[114] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*pow(Hs[114],2) - 2*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[115] + 2*aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[115] - 2*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[114]*Hs[115] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*pow(Hs[115],2) + pow(E,yss[2])*pbar*Pssp*pow(Gs[226] + Hs[116],2) + 2*(dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[225]) + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[226] + pow(E,yss[11])*Gs[235] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[114] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[115] + pow(E,yss[2])*pbar*(Gs[226] + Hs[116]));
	Ncc_sp_s[14]=(2*Pssp*zbar*Hs[113]*(Gs[235] - Hs[115]) - Pssp*zbar*pow(Gs[235] - Hs[115],2)*xss[1] + 2*(dP2ssp*Gs[233] + dP1ssp*Gs[234])*(pow(E,yss[11])*Gs[236] - zbar*Hs[113] + zbar*(Gs[235] - Hs[115])*xss[1]))/pow(E,yss[11]);
	Ncc_sp_s[15]=(-2*Pssp*zbar*Hs[113]*Hs[115] - Pssp*(-1 + zbar)*pow(Gs[235],2)*xss[1] - Pssp*zbar*pow(Hs[115],2)*xss[1] + 2*Pssp*zbar*Gs[235]*(Hs[113] + Hs[115]*xss[1]) - 2*(dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-(pow(E,yss[11])*Gs[237]) + zbar*Hs[113] - (-1 + zbar)*Gs[235]*xss[1] + zbar*Hs[115]*xss[1]))/pow(E,yss[11]);
	Ncc_sp_s[16]=pow(E,yss[0] - yss[11])*Pssp*pow(Gs[224],2) + pow(E,yss[3] - yss[11])*Pssp*pow(Gs[227],2) - Pssp*pow(Gs[235],2) + ((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar))*Pssp*pow(Gs[235],2))/pow(E,yss[11]) + ebar*Pssp*pow(Hs[118],2) + (2*Pssp*Gs[235]*(-(pow(E,yss[0])*Gs[224]) - pow(E,yss[3])*Gs[227] + pow(E,yss[11])*Gs[235] - pow(E,yss[11])*ebar*Hs[118]))/pow(E,yss[11]) + (2*(dP2ssp*Gs[233] + dP1ssp*Gs[234])*(pow(E,yss[0])*Gs[224] + pow(E,yss[3])*Gs[227] - pow(E,yss[0])*Gs[235] - pow(E,yss[3])*Gs[235] - pow(E,yss[11])*ebar*Gs[235] + pow(E,yss[11])*Gs[238] + pow(E,yss[11])*ebar*Hs[118]))/pow(E,yss[11]);
	Ncc_sp_s[17]=(2*(dP2ssp*Gs[233] + dP1ssp*Gs[234])*(bbeta*pow(E,yss[8])*Gs[239] + pow(zbar,rrho)*(-Gs[233] + (-(rrho*rrhoz) + Gsp[56])*Hs[115]*yss[9] + (Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119])*yss[9])) + Pssp*pow(zbar,rrho)*(2*Gs[233]*Gsp[232] + 2*Gs[233]*Gsp[8]*Hs[112] + 2*Gs[233]*Gsp[24]*Hs[113] + 2*Gs[233]*Gsp[40]*Hs[114] + 2*Gs[233]*Gsp[72]*Hs[116] + 2*Gs[233]*Gsp[88]*Hs[117] + 2*Gs[233]*Gsp[104]*Hs[118] + 2*Gs[233]*Gsp[120]*Hs[119] - pow(rrho,2)*pow(ssigmazsp,2)*yss[9] + G2sp[2056]*yss[9] + G2sp[2312]*yss[9] + G2sp[2568]*yss[9] + G2sp[2824]*yss[9] + G2sp[3080]*yss[9] + G2sp[3336]*yss[9] - pow(Gsp[136],2)*yss[9] + 2*rrho*ssigmazsp*Gsp[152]*yss[9] - pow(Gsp[152],2)*yss[9] - pow(Gsp[168],2)*yss[9] - pow(Gsp[184],2)*yss[9] - pow(Gsp[200],2)*yss[9] - pow(Gsp[216],2)*yss[9] - pow(Gsp[232],2)*yss[9] + 2*G2sp[232]*Hs[112]*yss[9] - 2*Gsp[8]*Gsp[232]*Hs[112]*yss[9] + G2sp[8]*pow(Hs[112],2)*yss[9] - pow(Gsp[8],2)*pow(Hs[112],2)*yss[9] + 2*G2sp[472]*Hs[113]*yss[9] - 2*Gsp[24]*Gsp[232]*Hs[113]*yss[9] + 2*G2sp[24]*Hs[112]*Hs[113]*yss[9] - 2*Gsp[8]*Gsp[24]*Hs[112]*Hs[113]*yss[9] + G2sp[264]*pow(Hs[113],2)*yss[9] - pow(Gsp[24],2)*pow(Hs[113],2)*yss[9] + 2*G2sp[712]*Hs[114]*yss[9] - 2*Gsp[40]*Gsp[232]*Hs[114]*yss[9] + 2*G2sp[40]*Hs[112]*Hs[114]*yss[9] - 2*Gsp[8]*Gsp[40]*Hs[112]*Hs[114]*yss[9] + 2*G2sp[280]*Hs[113]*Hs[114]*yss[9] - 2*Gsp[24]*Gsp[40]*Hs[113]*Hs[114]*yss[9] + G2sp[520]*pow(Hs[114],2)*yss[9] - pow(Gsp[40],2)*pow(Hs[114],2)*yss[9] + (-(pow(rrho,2)*pow(rrhoz,2)) + G2sp[776] + 2*rrho*rrhoz*Gsp[56] - pow(Gsp[56],2))*pow(Hs[115],2)*yss[9] + 2*G2sp[1192]*Hs[116]*yss[9] - 2*Gsp[72]*Gsp[232]*Hs[116]*yss[9] + 2*G2sp[72]*Hs[112]*Hs[116]*yss[9] - 2*Gsp[8]*Gsp[72]*Hs[112]*Hs[116]*yss[9] + 2*G2sp[312]*Hs[113]*Hs[116]*yss[9] - 2*Gsp[24]*Gsp[72]*Hs[113]*Hs[116]*yss[9] + 2*G2sp[552]*Hs[114]*Hs[116]*yss[9] - 2*Gsp[40]*Gsp[72]*Hs[114]*Hs[116]*yss[9] + G2sp[1032]*pow(Hs[116],2)*yss[9] - pow(Gsp[72],2)*pow(Hs[116],2)*yss[9] + 2*G2sp[1432]*Hs[117]*yss[9] - 2*Gsp[88]*Gsp[232]*Hs[117]*yss[9] + 2*G2sp[88]*Hs[112]*Hs[117]*yss[9] - 2*Gsp[8]*Gsp[88]*Hs[112]*Hs[117]*yss[9] + 2*G2sp[328]*Hs[113]*Hs[117]*yss[9] - 2*Gsp[24]*Gsp[88]*Hs[113]*Hs[117]*yss[9] + 2*G2sp[568]*Hs[114]*Hs[117]*yss[9] - 2*Gsp[40]*Gsp[88]*Hs[114]*Hs[117]*yss[9] + 2*G2sp[1048]*Hs[116]*Hs[117]*yss[9] - 2*Gsp[72]*Gsp[88]*Hs[116]*Hs[117]*yss[9] + G2sp[1288]*pow(Hs[117],2)*yss[9] - pow(Gsp[88],2)*pow(Hs[117],2)*yss[9] + 2*G2sp[1672]*Hs[118]*yss[9] - 2*Gsp[104]*Gsp[232]*Hs[118]*yss[9] + 2*G2sp[104]*Hs[112]*Hs[118]*yss[9] - 2*Gsp[8]*Gsp[104]*Hs[112]*Hs[118]*yss[9] + 2*G2sp[344]*Hs[113]*Hs[118]*yss[9] - 2*Gsp[24]*Gsp[104]*Hs[113]*Hs[118]*yss[9] + 2*G2sp[584]*Hs[114]*Hs[118]*yss[9] - 2*Gsp[40]*Gsp[104]*Hs[114]*Hs[118]*yss[9] + 2*G2sp[1064]*Hs[116]*Hs[118]*yss[9] - 2*Gsp[72]*Gsp[104]*Hs[116]*Hs[118]*yss[9] + 2*G2sp[1304]*Hs[117]*Hs[118]*yss[9] - 2*Gsp[88]*Gsp[104]*Hs[117]*Hs[118]*yss[9] + G2sp[1544]*pow(Hs[118],2)*yss[9] - pow(Gsp[104],2)*pow(Hs[118],2)*yss[9] + 2*G2sp[1912]*Hs[119]*yss[9] - 2*Gsp[120]*Gsp[232]*Hs[119]*yss[9] + 2*G2sp[120]*Hs[112]*Hs[119]*yss[9] - 2*Gsp[8]*Gsp[120]*Hs[112]*Hs[119]*yss[9] + 2*G2sp[360]*Hs[113]*Hs[119]*yss[9] - 2*Gsp[24]*Gsp[120]*Hs[113]*Hs[119]*yss[9] + 2*G2sp[600]*Hs[114]*Hs[119]*yss[9] - 2*Gsp[40]*Gsp[120]*Hs[114]*Hs[119]*yss[9] + 2*G2sp[1080]*Hs[116]*Hs[119]*yss[9] - 2*Gsp[72]*Gsp[120]*Hs[116]*Hs[119]*yss[9] + 2*G2sp[1320]*Hs[117]*Hs[119]*yss[9] - 2*Gsp[88]*Gsp[120]*Hs[117]*Hs[119]*yss[9] + 2*G2sp[1560]*Hs[118]*Hs[119]*yss[9] - 2*Gsp[104]*Gsp[120]*Hs[118]*Hs[119]*yss[9] + G2sp[1800]*pow(Hs[119],2)*yss[9] - pow(Gsp[120],2)*pow(Hs[119],2)*yss[9] + 2*Hs[115]*(Gs[233]*(-(rrho*rrhoz) + Gsp[56]) + (G2sp[952] + (rrho*rrhoz - Gsp[56])*Gsp[232] + G2sp[56]*Hs[112] + rrho*rrhoz*Gsp[8]*Hs[112] - Gsp[8]*Gsp[56]*Hs[112] + G2sp[296]*Hs[113] + rrho*rrhoz*Gsp[24]*Hs[113] - Gsp[24]*Gsp[56]*Hs[113] + G2sp[536]*Hs[114] + rrho*rrhoz*Gsp[40]*Hs[114] - Gsp[40]*Gsp[56]*Hs[114] + G2sp[792]*Hs[116] + rrho*rrhoz*Gsp[72]*Hs[116] - Gsp[56]*Gsp[72]*Hs[116] + G2sp[808]*Hs[117] + rrho*rrhoz*Gsp[88]*Hs[117] - Gsp[56]*Gsp[88]*Hs[117] + G2sp[824]*Hs[118] + rrho*rrhoz*Gsp[104]*Hs[118] - Gsp[56]*Gsp[104]*Hs[118] + (G2sp[840] + (rrho*rrhoz - Gsp[56])*Gsp[120])*Hs[119])*yss[9])))/(bbeta*pow(E,yss[8]));
	Ncc_sp_s[18]=-2*(dP2ssp*Gs[233] + dP1ssp*Gs[234])*Hs[114];
	Ncc_sp_s[19]=-2*(dP2ssp*Gs[233] + dP1ssp*Gs[234])*Hs[115];
	Ncc_sp_s[20]=-2*(dP2ssp*Gs[233] + dP1ssp*Gs[234])*Hs[116];
	Ncc_sp_s[21]=-2*(dP2ssp*Gs[233] + dP1ssp*Gs[234])*Hs[119];
	Ncc_sp_s[22]=-2*(dP2ssp*Gs[233] + dP1ssp*Gs[234])*Hs[118];
	Ncc_sp_s[23]=-2*(dP2ssp*Gs[233] + dP1ssp*Gs[234])*Hs[117];

}
